import pandas as pd
import numpy as np
from typing import List, Dict

import dataiku

from ..agentic_insights_toolkit.utils.analysis_session import trigger_main_analysis_session_scenario

def convert_nan_to_none(data: List[Dict]) -> List[Dict]:
    """Convert pandas/numpy NaN values to None for JSON serialization."""
    if not data:
        return data
    
    cleaned_data = []
    for row in data:
        cleaned_row = {}
        for key, value in row.items():
            # Check if value is NaN (pandas/numpy NaN)
            # pd.isna() handles None, NaN, NaT, and other pandas null values
            try:
                if pd.isna(value):
                    cleaned_row[key] = None
                else:
                    cleaned_row[key] = value
            except (TypeError, ValueError):
                # If pd.isna() fails (e.g., for non-scalar types), check with numpy
                try:
                    if isinstance(value, float) and np.isnan(value):
                        cleaned_row[key] = None
                    else:
                        cleaned_row[key] = value
                except (TypeError, ValueError):
                    # If all checks fail, keep the original value
                    cleaned_row[key] = value
        cleaned_data.append(cleaned_row)
    
    return cleaned_data

def start_new_analysis_session(session_params, session_param_dataset_name = "analysis_session_parameters"):
    df_session_params = pd.DataFrame([session_params])
    analysis_session_params_ds = dataiku.Dataset(session_param_dataset_name)
    analysis_session_params_ds.write_with_schema(df_session_params)
    
    # Trigger Main Analysis Session Scenario
    scenario_run_insights = trigger_main_analysis_session_scenario()
    
    # Return Scenario Insights
    return scenario_run_insights