from .config import init_config
init_config()

from flask import Flask
from flask_cors import CORS
import os

from webaiku.extension import WEBAIKU

from .api.analysis_session_api import analysis_session_api

app = Flask(__name__)
CORS(app, origins=["http://127.0.0.1:4200"]) 
WEBAIKU(
    app, "webapps/agentic_insights", int(os.getenv("VITE_API_PORT"))
)
WEBAIKU.extend(app, [analysis_session_api])

if __name__ == "__main__":
    app.run(host="127.0.0.1", port=int(os.getenv("VITE_API_PORT")), debug=True)