import type { StartAnalysisSessionData } from '@/Api'

/**
 * Session metadata interface
 * Contains all the data that can be provided from the user interface
 */
export interface SessionMetadata {
  selectedDataset: string
  selectedAnalyses: string[]
  enableTargetVariable: boolean
  useBusinessRules: boolean
  additionalContext: string
  manualTargetColForRCA: string
  reportTemplateId: string
  availableColumns: string[]
  startDatetime?: string
  endDatetime?: string
}

/**
 * Default session metadata values
 */
export const defaultSessionMetadata: SessionMetadata = {
  selectedDataset: '',
  selectedAnalyses: [],
  enableTargetVariable: true,
  useBusinessRules: true,
  additionalContext: '',
  manualTargetColForRCA: '',
  reportTemplateId: '',
  availableColumns: [],
  startDatetime: undefined,
  endDatetime: undefined,
}

/**
 * Convert SessionMetadata to StartAnalysisSessionData for API request
 */
export function convertSessionMetadataToApiData(
  metadata: SessionMetadata,
  analysisSessionId: string
): StartAnalysisSessionData {
  return {
    analysis_session_id: analysisSessionId,
    input_datasets: metadata.selectedDataset ? [metadata.selectedDataset] : [],
    analysis_to_perform: metadata.selectedAnalyses || [],
    infer_target_variable: metadata.enableTargetVariable,
    additional_context: metadata.additionalContext || '',
    manual_target_col_for_rca: metadata.manualTargetColForRCA || '',
    report_template_id: metadata.reportTemplateId || '',
    start_datetime: metadata.startDatetime,
    end_datetime: metadata.endDatetime,
  }
}

