import { API } from '@/Api'

/**
 * Option type for select dropdowns
 */
export interface SelectOption {
  label: string
  value: string
}

/**
 * Analysis option type (alias for SelectOption)
 */
export type AnalysisOption = SelectOption

/**
 * Load analysis types from API
 * Returns the analysis options or empty array if API fails
 */
export async function loadAnalysisTypes(): Promise<AnalysisOption[]> {
  try {
    const response = await API.getAllAnalysisTypes()
    if (response.data.ok && response.data.all_analysis_types) {
      // API now returns objects with label and value directly
      return response.data.all_analysis_types as AnalysisOption[]
    }
    return []
  } catch (error) {
    console.error('Error loading analysis types:', error)
    return []
  }
}

/**
 * Load input datasets from API
 * Returns the dataset options or empty array if API fails
 */
export async function loadInputDatasets(): Promise<SelectOption[]> {
  try {
    const response = await API.getAllInputDatasets()
    if (response.data.ok && response.data.all_input_datasets) {
      // API now returns objects with label and value directly
      return response.data.all_input_datasets as SelectOption[]
    }
    return []
  } catch (error) {
    console.error('Error loading input datasets:', error)
    return []
  }
}

