import { defineConfig } from 'vite'
import tailwindcss from '@tailwindcss/vite'
import vue from '@vitejs/plugin-vue'
import dotenv from 'dotenv'
import { fileURLToPath, URL } from 'node:url'

dotenv.config()

const clientPort = String(process.env['VITE_CLIENT_PORT'] || '5173')
const apiPort = Number(process.env["VITE_API_PORT"] || '5000')
const basePath = process.env[`DKU_CODE_STUDIO_BROWSER_PATH_${clientPort}`]
  ? String(process.env[`DKU_CODE_STUDIO_BROWSER_PATH_${clientPort}`]) + "/"
  : ""

export default defineConfig({
  server: {
    host: "127.0.0.1",
    port: Number(clientPort),
    proxy: {
      "/api": {
        target: `http://127.0.0.1:${apiPort}`,
        changeOrigin: true,
        secure: false,
        rewrite: (path) => path.replace(/^\/api/, "/api"),
      },
    },
  },
  plugins: [
    vue(),
    tailwindcss(),
  ],
  base: basePath,
  resolve: {
    alias: {
      '@': fileURLToPath(new URL('./src', import.meta.url))
    },
    dedupe: ['vue']
  },
  build: {
    outDir: 'dist',
    assetsDir: 'assets',
  },
})