import dataiku

from agentic_insights.backend.agentic_insights_toolkit.dku_utils.object import find_agent
from agentic_insights.backend.agentic_insights_toolkit.dku_utils.utils import get_project_variables

project = dataiku.api_client().get_default_project()

MAIN_AGENT_NAME = "va_main_agent"
REPORT_AGENT_NAME = "va_report_assistant"

local_vars = get_project_variables("local")


# 1) Setup project agents
def setup_agent_llm(agent_name, target_llm_id):
    agent = find_agent(agent_name)
    agent_sett = agent.get_settings()
    agent_sett_raw = agent_sett.get_raw()
    agent_sett_raw['versions'][0]['toolsUsingAgentSettings']['llmId'] = target_llm_id
    agent_sett.save()

setup_agent_llm(MAIN_AGENT_NAME, local_vars['MAIN_AGENT_LLM_ID'])
setup_agent_llm(REPORT_AGENT_NAME, local_vars['REPORT_AGENT_LLM_ID'])


#2) Setup Prompt Recipe LLM (main agent)
main_agent = find_agent(MAIN_AGENT_NAME)

prompt_recipe = project.get_recipe('compute_analysis_session_outputs')
prompt_recipe_sett = prompt_recipe.get_settings()
prompt_recipe_sett_json_payload = prompt_recipe_sett.get_json_payload()

prompt_recipe_sett_json_payload['llmId'] = main_agent.as_llm().llm_id

prompt_recipe_sett.set_json_payload(prompt_recipe_sett_json_payload)

prompt_recipe_sett.save()