## Requirements
---

Before installing the Agentic Insights project, ensure that all technical requirements specified in the **Technical Requirements** section are met.

**Note**: Other project assets (datasets, flow zones, recipes, scenarios) are already provided with the project and do not need to be created manually.

<br>

## Installation Steps
---

1. **Import the Project**: Import the Agentic Insights project into Dataiku and perform any required remapping during the import phase

2. **Project Setup**: Go to the project setup at the project's homepage and configure the necessary settings as explained in that section.

3. **Add Input Datasets**: Import your input datasets and store them in the **Input Datasets** flow zone to make them available for analysis

4. **Start Report Assistant Webapp**: Start manually (if not auto-started) the `ai_report_assistant` Agent Hub webapp to enable the AI assistant functionality

   <div class="alert">
   <p><strong>Important Configuration Note</strong>: If you encounter errors with the AI assistant, verify the Agent Hub configuration:</p>
   <ul>
   <li>Go to <strong>Admin Settings</strong> of the <code>ai_report_assistant</code> Agent Hub webapp</li>
   <li>In <strong>Enterprise Agents</strong>, ensure the agent points to the Visual Agent named <code>va_report_assistant</code> in the <strong>same project</strong></li>
   <li><strong>Note</strong>: When duplicating projects, Agent Hub may incorrectly point to the Visual Agent in the original project instead of the duplicated one, which can cause errors. Always verify and update the agent reference to point to the Visual Agent in the current project.</li>
   </ul>
   </div>

5. **Launch Main Interface**: Start manually (if not auto-started) and begin using the **Agentic Insights - Main Interface** webapp

<br>

## Important Notes
---

<div class="alert">

<p><strong>Do not change the following names</strong> as they are configured in the project backend:</p>

<ul>
<li><strong>Agent Hub Webapp Name</strong>: The name (not ID) of the Agent Hub webapp must remain unchanged as it's configured in the project backend to enable connection via the main webapp</li>
<li><strong>Input Datasets Flow Zone Name</strong>: The name (not ID) of the Input Datasets flow zone must remain unchanged as it's configured in the project backend to enable automatic dataset import via the webapp</li>
<li><strong>Folder and Dataset Names</strong>: Do not change the names of folders and datasets as they are configured in the project backend</li>
</ul>

</div>
