The Report Assistant Agent follows a structured approach to help users explore and interpret existing analysis reports. This document describes the architecture, workflow, and design principles.

<br>

## Key Principles
---

- **Guidance Only**: The agent guides users through existing reports and data; it does not create new analyses
- **Proactive**: Uses tools proactively without waiting for explicit requests to provide comprehensive answers
- **Evidence-Based**: All insights must be grounded in retrieved content from tools, never fabricated
- **Concise & Actionable**: Keeps outputs concise, structured, and decision-ready
- **Tool-Limited**: Uses only the available tools listed; no external knowledge or assumptions


<br>

## Design
---

As for the Main Agent, we leverage Dataiku's native capabilities to create agents by implementing this agent as a Dataiku Visual Agent. Customized tools have been developed for this agent too to meet this specific need.

To simplify things, this agent can be seen as a **ReAct Agent** that reasons about what information the user needs and proactively uses tools to retrieve and explain report content, iterating between understanding user questions and providing comprehensive answers.

The diagram below illustrates the Report Assistant Agent (`va_report_assistant`) architecture, showing the central agent connected to its specialized tools that enable report interpretation and exploration.

![report_assistant_agent_overview.png](Gk2xyi8GgIkR)


<br>

## Components
---

### Prompt

The prompt defines the agent's logic and behavior, establishing it as a seasoned Data Analyst in Dataiku focused on report interpretation. It provides the complete instruction set for helping users understand and explore existing analysis reports. This Prompt:
- Defines the agent's role as a guide for report interpretation and dataset exploration (not for creating new analyses)
- Establishes a structured workflow from understanding questions to suggesting next steps
- Sets critical restrictions: no fabrication, must ground all insights in retrieved content, use only available tools

<br>

### Tools

The agent uses a set of specialized tools:

- `analysis_session_params_retriever`: Retrieves session parameters (analysis session ID, input datasets, selected analyses, etc.) to understand the analysis context
- `analysis_report_retriever`: Retrieves the full generated analysis report for inspection and interpretation
- `dataset_explorer`: Explores dataset structure, schema, statistics, missing values, and anomalies to help users understand the underlying data
- `analysis_flow_retriever`: Retrieves and describes the Dataiku Flow used to produce the analysis, explaining the sequence of analytic steps

<br>

## How It Works
---

The agent follows a nominal execution flow through 6 main steps:

- **1. Understand the Question**
The agent identifies what the user wants to explore (metrics, flow, dataset quality, anomalies, etc.) and determines which tools to use to provide comprehensive answers.

<br>

- **2. Extract Analysis Parameters**
The agent uses `analysis_session_params_retriever` to retrieve session parameters such as the analysis session ID, which provides context about the analysis that was performed.

<br>

- **3. Proactively Select and Use Tools**
The agent proactively selects the right tools without waiting for explicit user requests:
  - Uses `analysis_report_retriever` to retrieve report details and content
  - Uses `dataset_explorer` to profile dataset structure, columns, distributions, missing values, and anomalies
  - Uses `analysis_flow_retriever` to explain the sequence of analytic steps and the Dataiku Flow structure

<br>

- **4. Interpret & Summarize**
The agent translates technical outputs from tools into clear, business-ready insights. It summarizes report sections, interprets dataset properties, and explains analysis flow in an accessible way.

<br>

- **5. Infer & Enrich**
The agent goes beyond surface-level answers by highlighting relevant KPIs, missing data patterns, dependencies, or anomalies, even if not directly asked. It proactively provides additional context and insights.

<br>

- **6. Suggest Next Exploration**
The agent proposes logical follow-up explorations (e.g., inspect a KPI trend, check dependencies in flow, validate data quality) to help users dive deeper into the analysis.

<br>

## Integration
---

The Report Assistant Agent is:
- **Configured** via [Dataiku Agent Hub](web_app:imcMyOL)
- **Embedded** in the webapp as an interactive iframe component in the Report Viewer section
- **Enabled/Disabled** by users via a toggle switch in the webapp interface
- **Context-Aware** when a report is displayed, it can access the analysis session ID and related information

