The Main Agent has access to a comprehensive set of tools organized into three categories: Core Tools, Analytic Tools, and Report Tools.

<br>

## Core Tools
---

### [Analysis Initiator](agent_tool:Kdp2hs7)

**Purpose**: Initialize a new analysis session and set up environment parameters.

**Usage**: 
- **Mandatory**: Must be called as the first step in every analysis
- Sets up the analysis session environment by:
  - Generating a unique session ID (if not already automatically generated by the webapp and provided in the inputs)
  - Creating a flow zone specific to the current analysis session (`analysis_session_{id}`)


**When to Use**: Always at the beginning of an analysis workflow.

<br>

### [Dataset Explorer](agent_tool:v9OSAm3)

**Purpose**: Explore dataset schema, sample data, and data quality metrics.

**Capabilities**:
- Inspect dataset schemas (columns, data types)
- Analyze data distributions
- Identify missing data patterns
- Assess data quality metrics
- Sample data preview

**Usage**:
- Always validate input datasets first before proceeding
- Identify potential data quality issues early
- Understand data structure and characteristics

**Output**: 
- Schema information
- Data quality metrics
- Sample data
- Distribution statistics


<br>


### [Business Rules Explorer](agent_tool:AIs3Eil)

**Purpose**: Retrieve active business rules applicable to the analysis context.

**Capabilities**:
- Query the `business_rules` dataset
- Filter for active rules only (`flag_active = True`)
- Retrieve rule content and constraints

**Usage**:
- Always retrieve business rules when `useBusinessRules` is enabled
- Consider rules during planning, data processing, and result interpretation
- Ensure final report and analytic plan comply with rules

**Output**: 
- List of active business rules
- Rule content and constraints
- Applicable policies

**Important**: Business rules must be explicitly considered throughout the analysis workflow.

<br>

## Analytic Tools
---

### [Analytic Tools Explorer](agent_tool:x4QIsVm)

**Purpose**: Discover available analytic tools and their capabilities.

**Capabilities**:
- Query the `analytic_tools` dataset
- Filter for active tools only (`flag_active = True`)
- Retrieve tool descriptions and capabilities

**Usage**:
- Discover what analyses are possible
- Understand tool capabilities before selection
- Plan which tools to use based on business question

**Output**: 
- List of available analytic tools
- Tool IDs, names, and descriptions
- Capability overview

**Available Tools** (examples):
- `analytic_clustering`: KMeans clustering analysis
- `analytic_outlier_detection`: Outlier detection using Isolation Forest
- `analytic_time_series_forecasting`: Time series forecasting with Prophet
- `analytic_root_cause_analysis`: Root cause analysis for target variables

<br>

### [Analytic Tool Argument Retriever](agent_tool:f4EerPT)

**Purpose**: Retrieve required parameters and argument structure for a specific analytic tool.

**Capabilities**:
- Get detailed parameter requirements for a specific tool
- Understand input/output structure
- Learn about optional vs. required parameters

**Usage**:
- Call after selecting a tool via `analytic_tools_explorer`
- Retrieve parameters only for tools you decide to use
- Optimizes token usage by avoiding upfront loading of all tool details

**Input**: 
- `analytic_tool_id`: The ID of the tool to get parameters for

**Output**: 
- Required parameters
- Optional parameters
- Parameter descriptions
- Input/output structure

<br>

### [Analytic Tool Executor](agent_tool:sMFcFmE)

**Purpose**: Execute an analytic tool with provided arguments.

**Capabilities**:
- Execute any available analytic tool
- Pass parameters via `input_args` dictionary
- Run tools in parallel when possible (for optimization)

**Usage**:
- After retrieving tool parameters via `analytic_tool_arg_retriever`
- Provide all required parameters in `input_args` dictionary
- Execute multiple tools in parallel when they don't depend on each other

**Output**: 
- Execution status
- Results preview
- Output dataset references
- Insight dataset references

**Important**: Each analytic tool accepts a single dictionary argument named `input_args` containing all required parameters.

<br>

## Report Tools
---

### [Report Script Data Template Retriever](agent_tool:diOHkca)

**Purpose**: Retrieve a small template section (the `report_data` JavaScript structure) that will be integrated into the final report.

**Capabilities**:
- Get the report data structure template
- Understand expected data format
- See placeholders for required fields

**Usage**:
- Call before generating the final report
- Use template as a guide for structure and format
- **CRITICAL**: Must preserve the complete JavaScript declaration: `const report_data = {...}`
- Do NOT extract only the object content

**Output**: 
- JavaScript template structure
- Placeholder fields
- Expected data format

<br>

### [Full Report Generator](agent_tool:cnjr20R)

**Purpose**: Generate the final HTML report.

**Capabilities**:
- Leverages the agent's response that contains extracted structured data (KPIs, chart data, statistics) from insight datasets
- Incorporates this data into the final report in a deterministic way by merging the dynamic part (AI-generated content) with the static part (manually defined template)
- Assembles a complete, standalone HTML report following template structure
- Embeds all styles, scripts, and assets

**Usage**:
- Final step in the analysis workflow
- After all analytic tools have been executed
- After retrieving the report template structure

**Process**:
1. Extracts structured data (KPIs, chart data, statistics) from insight datasets generated by analytic tools
2. Incorporates agent-generated textual insights (findings, interpretations, actions)
3. Merges the dynamic content (extracted data and AI-generated insights) with the static template structure (predefined HTML, CSS, JavaScript helper functions)
4. Embeds all required assets (CSS styles, JavaScript functions) into the HTML file
5. Generates the final standalone HTML file 

**Output**: 
- Complete HTML report file
- Saved to `analysis_reports` folder as `{analysis_session_id}.html`
- Fully standalone (all assets embedded)


<br>

## [Available Analytic Tools](dataset:analytic_tools)
---

The Main Agent can execute various analytic tools to perform different types of analysis. Below is a simple description of each available tool:

### Clustering

**What it does**: Groups similar data points together into clusters based on their characteristics.

**Use case**: Discover natural groupings in your data, identify customer segments, or find patterns in behavior.

**Output**: 
- Dataset with cluster labels assigned to each row
- Insights about cluster characteristics, sizes, and quality metrics

**Key features**: Automatically handles both numeric and categorical data, determines optimal number of clusters if not specified.

**How it works**: Uses the KMeans clustering algorithm to partition data into groups. For numeric features, it standardizes the data to ensure all features contribute equally. For categorical features, it applies encoding (one-hot encoding for low-cardinality categories). The tool automatically tests different numbers of clusters using the elbow method to find the optimal number if not specified, and evaluates cluster quality using metrics like silhouette score and Davies-Bouldin index.


<br>


### Outlier Detection

**What it does**: Identifies unusual or anomalous data points that deviate significantly from the norm.

**Use case**: Find data quality issues, detect fraud, identify exceptional cases, or discover errors in data collection.

**Output**: 
- Dataset with an outlier flag for each row
- Summary of outliers by column, patterns, and recommendations

**Key features**: Works with both numeric and categorical columns, automatically identifies rare categories.

**How it works**: Uses the Isolation Forest algorithm for numeric columns, which identifies outliers by measuring how easily a data point can be isolated from the rest. For categorical columns, it identifies rare categories that appear in less than 1% of the data. The algorithm builds isolation trees and calculates an anomaly score for each data point, flagging those with scores above a threshold (contamination parameter).


<br>


### Time Series Forecasting

**What it does**: Predicts future values based on historical time-based data patterns.

**Use case**: Forecast sales, predict demand, estimate future trends, or plan for seasonal variations.

**Output**: 
- Dataset with historical data and forecasted future values
- Forecast accuracy metrics, trend analysis, and seasonality insights

**Key features**: Uses Prophet model, supports different time frequencies (daily, weekly, monthly, etc.), provides confidence intervals.

**How it works**: Uses Facebook's Prophet model, which decomposes time series into trend, seasonality, and holiday components. The data is first aggregated by the specified frequency (daily, weekly, monthly, quarterly, or yearly) using the chosen aggregation method (mean, sum, etc.). Prophet then fits a model that captures long-term trends, seasonal patterns, and can optionally account for holidays or special events. The model generates forecasted values along with upper and lower confidence intervals, and provides accuracy metrics (MAE, RMSE, MAPE) when historical data is available for validation.


<br>


### Root Cause Analysis

**What it does**: Identifies which factors (features) most strongly influence or drive a target variable of interest.

**Use case**: Understand what drives performance, identify key success factors, or determine what causes specific outcomes.

**Output**: 
- Feature importance rankings
- Correlation analysis, categorical impacts, and identified root causes with evidence

**Key features**: Analyzes both numeric and categorical relationships, provides statistical evidence for each root cause.

**How it works**: Performs comprehensive statistical analysis to identify drivers of a target variable. For numeric features, it calculates Pearson and Spearman correlation coefficients to measure linear and monotonic relationships. For categorical features, it uses ANOVA (Analysis of Variance) to test if different categories have significantly different means for the target variable. The tool ranks features by importance, detects interactions between features, and performs conditional analysis to understand complex relationships. Each identified root cause includes statistical evidence (correlation strength, significance tests, F-ratios) and confidence levels.