The Agentic Insights project uses Dataiku scenarios to orchestrate and manage the analysis workflow. Scenarios provide execution tracking, security, and monitoring capabilities through native Dataiku functionality.

A Dataiku Scenario enables: 

- **Execution Tracking**: Enables tracing of backend operations and analysis progress
- **Security**: Provides enhanced execution security through Dataiku's native scenario controls
- **Status Monitoring**: Allows tracking of execution status using Dataiku's scenario API
- **Logging**: Facilitates log monitoring and debugging through scenario run insights

<br>

## [Setup Agents](scenario:SETUP_AGENTS)
---

### Purpose

This scenario is used in the project setup to configure the project's agents based on user choices and the client's infrastructure. It sets up the main analysis agent and report assistant agent LLMs. This configuration must be completed before running any analysis sessions. 

<br>

### Usage

The scenario is triggered from the project setup interface (Project Prerequisites section). Users configure the agents by selecting the required LLMs parameters. 

This is a one-time setup that must be completed before launching any analysis sessions.



<br>

## [Main Analysis Session Scenario](scenario:MAIN_ANALYSIS_SESSION_SCENARIO)
---

### Purpose

The main scenario is triggered by the webapp to execute the main analysis recipe. It orchestrates the complete analysis workflow from session initialization to report generation.

<br>

### Usage

The scenario is automatically triggered when a user launches a new analysis session from the webapp. It runs the main recipe that launches the analysis session.

<br>

## [Delete Analysis History Scenario](scenario:DELETE_ANALYSIS_HISTORY)
---

### Purpose

This scenario allows manual cleanup of analysis flow zones outside of the webapp interface. It helps manage storage by keeping only a specified number of recent analysis flow zones.

<div class="alert">This scenario is not recommended for regular use. It should only be used when manual cleanup is necessary outside of the standard webapp workflow.
</div>

<br>

### Usage

This scenario is manually triggered for administrative cleanup tasks. It performs the following operations:
- **Target**: Deletes analysis flow zones that are tagged for deletion
- **Retention**: Keeps only N flow zones based on creation date (retains the most recent ones)
- **Selection Criteria**: Flow zones are sorted by creation date, and only the N most recent are preserved. The scenario targets flow zones based on specific project tags (set manually in the project library)
- **Manual Operation**: Intended for administrative cleanup tasks outside of the standard webapp workflow

<br>

### Configuration

The number of flow zones to retain can be configured directly in the scenario script by modifying the retention parameter.
