<div class="alert">
We highly encourage our users to carefully review this agentic framework, including its architecture and prompts, revise the framework as needed, and thoroughly test its performance with users' preferred LLMs before implementation.
</div> 

This document outlines the technical requirements and dependencies for the Agentic Insights solution. Ensure all requirements are met before installation and usage.

<br>

## Dataiku Version
---

This solution has been tested and is compatible with **Dataiku DSS 14.4+**.

<br>

## LLM Connections
---

LLM connections must be configured in Dataiku before using the solution:

- **Main Agent**: OpenAI GPT-5 or large context models are recommended due to the agent's complex architecture and need to perform multiple actions requiring large context windows
- **Report Assistant Agent**: OpenAI GPT-4.1+ models are recommended

<br>

**Tested LLMs:**

This solution has been tested with the following LLMs, but performance is not guaranteed:

- **OpenAI**: GPT-5 and GPT-4.1
- **Google**: Gemini 2.5 Flash and Gemini 2.5 Pro


<br>

## Plugins
---

The following plugin must be installed:

- **[Agent Hub](https://doc.dataiku.com/dss/latest/agents/agent-hub.html)** version **1.0.1+**

<br>


## Next Steps
---

Once all technical requirements are met, proceed with the installation steps described in the Usage/Installation section.

## Code Environment
Project python recipes uses the code env **solution_agentic-insights**.


Required packages for this code env are: 
>causal-learn
dotenv
dowhy
flask
langchain
pandas-toon
prophet
python-dotenv
pytoony
webaiku@git+https://github.com/dataiku/solutions-contrib.git@main#egg=webaiku&subdirectory=bs-infra






