Model Explainability is a key component in the AML process. Compliance teams need to understand precisely how the models they are using behave, and make sure they don't break under certain conditions. In the [dashboard](dashboard:zAy7r2U), the main components allowing us to investigate these explanations are described.
 
# Global Explanation
 
A first way of understanding how the model works is to have a look at the variable importance graph:
 
![Variable Importance.png](csGXjbJflFbr)
 
This graph represents the contribution of each variable in the model. Hence, we can understand which variables the model relies on most and which variables are maybe not very useful for the model to predict. Here, the orig_is_escalated_avg variable is the most important, it is the frequency of escalated transactions for the originator of the transactions. It should make sense from a business standpoint. Other important variables include amount, orig_is_alert_avg (the frequency of alerts among originator's transactions), and if the customer belongs to segment 4.
 
Another interesting view is the partial dependence plot:
 
![Partial Dependence.png](OrkVL16nTerJ)
 
For each of the variables in our dataset, this graph plots the target's dependence on this given variable. It is interesting to observe the dependencies for the most important variables to check that the shape of the curve matches intuition. For example, we would expect an increasing relationship between the is_escalated_avg variable with the target probability, which we do observe. Other relationships might be a bit surprising and could be investigated further like the decreasing relationship between is_alert_avg and amount with the target.
 
# Individual Explanation
 
Individual Explanations aim to dig a bit deeper and investigate at a much smaller granularity how the model behaves. A very interactive way of doing so is by exploring the interactive scoring view:
 
![Interactive Scoring.png](SyWtLvoHbANk)
 
The user can modify the values of each of the features and observe the output from the model. The model computes a probability and if this probability is over the threshold, the prediction is 1 otherwise 0. Along with the prediction are the most influential features, these features may change depending on the values of the features. The interesting data points can be added to the comparator to be compared side by side:
 
![Comparator.png](RyHBIcyDN84X)
 
Just by changing one of the features, the probability can move significantly, and the most influential features as well.
 
The other window called individual explanations focuses on the extreme probabilities: 
 
![Individual Explanations.png](qCSFoGjP435D)
 
There, similarly to the interactive scoring, it gives the most influential features that drove these predictions. This view allows to detect patterns in how the top and bottom predictions have been made and which variables impact had the greatest impact.
 
# Drift
 
In a dynamic setting, where new data gets in at a daily or weekly interval for example, having the static explanations is not enough to ensure that the model is still good enough as time goes by. This is the reason why drift must be carefully monitored. It is already done [here](article:13), by following the performance metrics. It can also be achieved within the [evaluation store](model_evaluation_store:qz8Oc6jF) view:
 
![Data Drift.png](Rlh3EBlxLayI)

When opening the evaluation store, historical metrics are displayed to view the performance over time of the model. In particular, we have pinned the data drift metric to check how much the data has changed from its original state. The computation consists in training a random forest classifier to discriminate the two datasets. The more accurate the model, the more distinguishable are the two datasets. Above 0.5, datasets are considered distinguishable, and some action should be taken like retraining the model on more recent data.

![Global Drift Score.png](u8siXdjlBtWv)

Then we select the latest evaluation and go to the Input data drift menu within the Drift Analysis section. The data drift score is displayed along with a binomial test to check if the data drifted. Here, the conclusion of the test is that some drift was detected, therefore the user should investigate further and maybe consider retraining a model with more recent data.

![Univariate Data Drift.png](s6FbXKW4OPWW)
 
Underneath the global view, each variable is checked for drift individually. Most of the variables have not significantly drifted but a few of them, like amount or bene_amount_min are highlighted with the exclamation mark, indicating the the distribution has significantly changed between the original validation set and the new one.
 
![Feature Drift Importance.png](wzG1nkYMjDxz)
 
Finally this very interesting graph cross analyses variable importance and drift importance for each variable. The y axis represents the feature importance in the original model while the x axis represents the feature importance in the drift model that discriminates between the original dataset and the drifted one. The variables that should be under scrutiny are the ones situated in the top right quadrant, these variables have both drifted significantly and have a great impact in the model. Variables situated on the bottom right have drifted a lot, but they are not very important in the model, so we may not need to worry about them. Similarly, variables on the top left are important, so we should monitor them carefully but they do not seem to have drifted.
 
![Fugacity.png](LykrQ8yVViCL)
 
Another way of observing how data has drifted over time is to look at the fugacity in the menu prediction drift. Fugacity compares the proportion of each predicted class for the two datasets. If these proportions deviate significantly, it should ring a bell for the user.
 
# Model Update
 
When the need for model update appears from the combination of performance and data drift analysis, the model can be retrained. In the flow the train dataset is up-to-date because it has been updated each time new data has come in. So the user simply can retrain the model and keep the same configuration. As a result, all the explanations described above will automatically be created. To validate the deployment of this new model, explanations and investigations can be compared between the deployed model and the newly trained side by side. If they don't differ significantly, the model could be deployed without any additional verification. If for example some variable which was very important previously drops from the top variables, the analyst should investigate deeper to understand why this happened and if it is justified.
 

