<span id="version" style="color: grey; float: right">Version 1.0.0</span><br/>

# About this wiki

This wiki outlines the design and implementation of a Churn Prediction Solution, which supports in identifying early signs of disengagement at the product level, so that intervention can be made before a customer abandons a product.



## Why Churn Prediction Matters?

- **Customer acquisition is resource-intensive** : Companies invest heavily in onboarding and compliance, while profitability depends on keeping customers engaged over time.  
- Many customers **silently disengage** : Instead of formally closing accounts, they reduce activity or balances, making attrition harder to detect.  
- **Churn is not always explicit** : Inactivity can signal exit risk well before a product is officially closed.  
- Churn is **progressive** : Loss of one product can precede the gradual erosion of the entire relationship.  
 
 

## What the Solution Does

 - Predicts churn at the  **product level using customer behavior patterns**  by predicting declines in revenue. Alternative methods could include declining balances or measures of reduced product activity.
 - Aggregates product-level churn to derive **customer-level churn risk**, helping **prioritize high-risk accounts**
 - Supports  **backward-looking churn labeling**  to analyse historical behaviour, and forward looking labelling which identifies churn risk before the customer exits in order  **to maximize time for retention action** .
 - Includes a flexible, scalable pipeline and an output ready for retention campaign targeting
 
 

## Solution Users

 - The dashboards are dedicated to business users like Relationship Managers, Product Owners, Heads of Customer Experience, Marketing Managers and Business Analysts. The Dashboards in the solution answer “What’s happening?” and “Who is at risk?”
 - The rest of the wiki is targetted at Data Analysts, Data Scientists, and Data Engineers who want to understand the solution’s logic and flow, customize inputs, features, churn logic, and outputs.


# Walkthrough

See  [Case Study and Walkthrough](article:2), which lays out the typical steps to leverage the churn Prediction Solution. It’s based on a retail banking use case and links out to in-depth documentation at each stage.