[5. Churn Definition](flow_zone:ffLuDEM) zone defines actual churn based on observed customer behavior, independent of any predictive model. It applies a backward-looking business rule to identify when a customer has stopped engaging with a specific product, and prepares the labeled dataset for further analysis and dashboarding.

![Screenshot 2025-08-14 at 09.28.04.png](KwIxJm5eRyre)

 **Actual Churn** :  A reliable churn flag for each customer-product-month using actual transactional patterns (not predictions), considering a horizon of past 3 months.

Here, a customer is labeled as  **churned**  if:
- They show  **3 consecutive months of zero revenue** , which is the beginning of  **disengagement **  for the customer on that particular product,  OR
- The product is  **officially closed**  (i.e., the current observation date equals the product end date)

>This rule is applied only to rows marked as "for_modelling".

For Actual Churn, following are the descriptions to understand the historical nature of the churn in the data.
- if the revenue is zero for 3 consecutive months, then this is inactivity_churned
- If the product is officially closed then it is product_end_churned.

**Row_flag_assignment:** 
The first prepare recipe consists of a step to distinguish between rows used for model training vs. inference (scoring) based on a fixed  **cutoff date** . 
- The cut-off date has to be selected as per your dataset to separate rows to be used for modelling(known labels) and inference dataset (unknown labels).
- This flag is used throughout the flow for controlled feature generation, labeling, and model evaluation.

Then, Based on the conditions outlined to defined actual churn label, the window recipe identifies the first churn date appearing in the data, per customer-product relation, is taken as the actual churned date for the product. Then the data is further prepared by basic data cleaning and dropping rows after actual churn date to ensure no leakage of data is passed on thereafter. 