Models are pushed to production using the [API](lambda_service:claim_risk). We create an API service with three endpoints:

- A prediction model endpoint for [Claim Frequency](saved_model:aHJZVrBQ)
- A prediction model endpoint for [Claim Severity](saved_model:j1Mpq3TM)
- A prediction model endpoint for [Pure Premium](saved_model:PVKl9xt0)

As all the feature processing is either in the script part of the analysis, or directly in the feature handling menu of the model, no enrichment is necessary beforehand.

![API Designer.png](VJ3GDRc81Sp0)

Queries can be tested by taking samples from one of the flow's datasets. We choose the [claim_frequency](dataset:claim_frequency) dataset which has the raw features that we would want as inputs of our model. Test queries enable us to check if the endpoint outputs sensible predictions.

![API Test Query.png](RfuKydNfJWPJ)

Pushing the API service on the API Node is very simple and explained in the [documentation](https://doc.dataiku.com/dss/latest/apinode/first-service-apideployer.html). Once it is running, real queries can be sent to the API service through the API deployer, or using sample code provided by the API deployer. We are calling the API in the [webapp](article:9) module of this project.