# 目的

このプロジェクトの目標は、過去の請求データに基づいて保険料設定モデルを作成することです。この調査に使用されるデータセットは、各行が1つの自動車保険証券となっており、運転者とその車に関する情報、および期間内に発生した請求金額を記録した別のデータセットが含まれています。この価格設定モデルは、潜在的な保険契約者ごとに、実際のリスクを正確に反映した価格を設定することを目的としています。

請求頻度や請求程度は特殊な挙動となり、通常は正規分布以外の分布を使用してモデル化されるため、その適合変数には一般化線形モデル（GLM）が必要です。しかし、一般的な機械学習アルゴリズム（GBM やニューラルネットワークなど）とは異なり、線形要素によるGLMでは、特徴量と結果の間に厳密な依存関係があります。したがって、これらの依存関係を直感と一致させ、結果の偏りを防ぐために、特徴量エンジニアリングがとくに重要となります。


# バリュー

このプロジェクトは、保険数理士（アクチュアリー）が Dataiku を使用して作業を行う際のテンプレートとなります。この種のモデリングに Dataiku を使用することのバリューは、次の 3 つの要素から成ります：
 - [ 一般化線形モデル適合](article:3): ビジュアル機械学習には、保険数理士（アクチュアリー）が堅牢で視覚的な環境で請求をモデル化できる GLM が含まれています。
 - [広範な探索的データ分析および特徴量エンジニアリング](article:4):入力データはさまざまな形式（数値、カテゴリカル、テキスト）をとる場合があり、モデリングへ移行する前にクレンジングと準備が必要になることがよくあります。また、組み込みの探索機能とグラフ機能により、データの理解を深めることができます。
 - [ API を使用して本番環境にプッシュ](article:5): fファイナライズされたモデルを API に簡単にデプロイし、Dataiku の外部または Web アプリケーションで出力を利用できます。