このゾーンでは、データセットを変換して各変数に対する結果のグラフを作成し、パターンを視覚化します。

![Univariate Analysis.png](oikm8VtQjkgo)

解析対象の変数と同じ数のグループ化レシピを使用することを避けるために、まず準備ステップを使用してすべての変数を折りたたみます。これにより、1 つのグループ化レシピのみを使用してすべての集約を計算できる、かなり長いデータセットが得られます。

次のウィンドウレシピでは、グループ化レシピで必要となる初期集約を作成します。これらの集約は、前に行った折りたたみの結果であるパーティショニングキー、 **grouping**  と  **group_value**  を使用して構築されます。請求数、請求金額、エクスポージャーの合計を計算します。

グループ化レシピでは、キーも   **grouping**  と  **group_value** です。請求数、請求金額の合計、およびエクスポージャーの合計の最小値を、集約として選択します。これらは実際の値です。同じ集約がすでにウィンドウレシピで作成されているからです（最大値を使用しても違いはありません）。メトリクスの推定値の不確実性を計算するために、カスタム集約を使用して、請求頻度、請求の程度、および純保険料の標準偏差を作成します。これらの標準偏差はそれぞれ、エクスポージャー、請求数、エクスポージャーによって重み付けされます。

```math
{\displaystyle sd(ClaimFrequency) = \sqrt{\frac{\sum{Exposure * (\frac{ClaimNb}{Exposure} - \frac{\sum{ClaimNb}}{\sum{Exposure}})^2}}{\sum{Exposure}}}}
```

```math
{\displaystyle sd(ClaimSeverity) = \sqrt{\frac{\sum{ClaimNb * (\frac{ClaimAmount}{ClaimNb} - \frac{\sum{ClaimAmount}}{\sum{ClaimNb}})^2}}{\sum{ClaimNb}}}}
```

```math
{\displaystyle sd(PurePremium) = \sqrt{\frac{\sum{Exposure * (\frac{ClaimAmount}{Exposure} - \frac{\sum{ClaimAmount}}{\sum{Exposure}})^2}}{\sum{Exposure}}}}
```

最後に、折りたたまれている  **grouping**  および  **group_value**  の各列を準備レシピで展開します。これには、まず  **grouping**  にダミー列を作成し、Python の準備ステップを使用して   **group_value**  から値を割り当てます。次に、請求頻度、請求程度、純保険料に対してそれぞれの比率を適用します。最後に、これらの推定値の上限と下限が、前に算出した標準偏差を使用して計算されます。

例えば、請求頻度の場合：

```math
{\displaystyle ClaimFrequencyUpperBound = ClaimFrequency + 1.96 \frac{sd(ClaimFrequency)}{\sqrt{\sum{Exposure}}}}
```

このゾーンの最終データセットで作成されたグラフが [ダッシュボード](dashboard:DbWZIwg)に表示されます。詳細については、 [Claim Frequency（請求頻度）](article:24), [Claim Severity（請求の重大度）](article:23) and [Pure Premium（純保険料）](article:25).