# 定義

一般化線形モデル（GLM）は、通常の線形回帰を一般化したものです。 正式には、このモデルは次のように記述できます。

```math
{\displaystyle \operatorname{E}(\mathbf{y}|\mathbf{X}) = g^{-1}(\mathbf{X}\boldsymbol{\beta})}
```

$`\mathbf{y}`$ がターゲット変数の場合 $`\mathbf{X}`$ は特徴量を表します。 このモデルは$`\mathbf{y}`$ が指 [指数型分布族](https://ja.wikipedia.org/wiki/%E6%8C%87%E6%95%B0%E5%9E%8B%E5%88%86%E5%B8%83%E6%97%8F) に属する事前定義された分布に従っていることを想定しています(とくに、正規、ポアソン、ガンマを含む)。 $`g`$はリンク関数です（よくある選択肢には、恒等、対数、逆数などが含まれる）。 また $`\boldsymbol{\beta}`$ は線形回帰の係数のベクトルです。

GLM の特殊なケースの一部はよく知られており、次のようなものです。

 - 通常の線形回帰：分布が正規で、リンク関数が恒等である場合
 - ロジスティック回帰：二項分布であり、リンク関数がロジットである場合

GLM 適合とは、トレーニングデータセットの尤度を最大にする$`\boldsymbol{\beta}`$を見つけることです。

# Claim Frequency（請求頻度）

請求頻度は、1 年あたりの請求数として定義されます。

```ClaimFrequency = ClaimNb / Exposure```

ここで、 ```ClaimNb``` は特定の保険契約者について報告された請求の数であり、```Exposure``` は保険契約の期間（年）です。そのため、請求頻度をモデル化するにあたっては、保険契約者が 1 年間に報告する請求数を予測する必要があります。すべての顧客が同時に契約を開始しているわけではないため、データセット内のエクスポージャーはそれぞれ異なる可能性があり、エクスポージャーによって正規化することで、比較可能な結果を得ることができます。

多くの場合、これは [ポアソン](https://ja.wikipedia.org/wiki/%E3%83%9D%E3%82%A2%E3%82%BD%E3%83%B3%E5%88%86%E5%B8%83) 分布としてモデル化されます。以下のグラフは、エクスポージャーを重みとして設定した、請求数の分布を表しています： [claim_train に基づく請求頻度](insight:kMwNWuA).

# Claim Severity（請求の重大度）

請求の重大度は、請求ごとの請求金額として定義されます。

```ClaimSeverity = ClaimAmount / ClaimNb```

ここで、 ```ClaimAmount``` は、特定の保険契約者について報告された請求の合計金額です。請求頻度と同様に、この正規化により請求金額が比較可能になります。この請求の重大度は、保険契約者から少なくとも 1 件の請求が報告された場合にのみ使用できます。

多くの場合、これは [ガンマ](https://ja.wikipedia.org/wiki/%E3%82%AC%E3%83%B3%E3%83%9E%E5%88%86%E5%B8%83) 分布としてモデル化されます。 以下のグラフでは、請求金額を重みとして設定した、請求金額の分布を表しています（ゼロを超える請求金額のみ）：[claim_train に基づく請求の重大度](insight:5mp7K9A) 。

# Pure Premium（純保険料）

純保険料は、特定の保険契約者に関する 1 年あたりの期待リスクであり、後で価格設定に使用されるモデリングの最終出力です。これは請求頻度と請求程度を組み合わせたものであり、次のように記述できます。

```PurePremium = ClaimAmount / Exposure = ClaimFrequency * ClaimSeverity```

この式からわかるように、純保険料は商品の請求頻度および請求の重大度の積として表せます。したがって、請求頻度と請求の重大度をモデル化することや、結果を乗算して純保険料を算出すること、あるいは純保険料を直接モデル化することが可能です。純保険料は通常、ゼロの多い分布に続き、ガンマ分布に似た請求金額の分布で表します。

純保険料は通常、ゼロの多い分布に続き、ガンマ分布に似た請求金額の分布で表します。ポアソンとガンマの組み合わせであるこの分布は[Tweedie](https://en.wikipedia.org/wiki/Tweedie_distribution) 分布と呼ばれます。以下のグラフでは、エクスポージャーを重みとして設定した、請求金額の分布を表しています（請求金額のみ）： [claim_train に基づく純保険料](insight:rMkR48N).

# GLM とその他のモデル

GLM を使用すると、保険数理士（アクチュアリー）は、単純な線形回帰ではモデル化できない現象をモデル化できるようになります。ただし、GLM の線形回帰では、特徴量と結果変数の間の依存関係に強い制約が課されます。この制約を回避するために、アナリストは特徴量を正確に設計し、変数間の共直線性を回避する必要があります。

結果変数の共変量間に、非線形性およびより複雑な依存関係を挿入するために、他のモデルが検討され始めています。例えば、決定木、勾配ブースティングマシン（GBM）、ニューラルネットワークなどです。これらのモデルでは、適合で結果分布を考慮に入れるために、指数型分布族の対数尤度や、目的関数としての逸脱度を使用する場合があります。