# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# -*- coding: utf-8 -*-
import dataiku
import pandas as pd, numpy as np
from dataiku import pandasutils as pdu
from sklearn.metrics import auc

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# Read recipe inputs
lorenz_curves = dataiku.Dataset("lorenz_curves")
lorenz_curves_df = lorenz_curves.get_dataframe()

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
ginis_values = []
measures = ['random', 'tweedie', 'product', 'oracle']
for measure in measures:
    ginis_values.append(1 - 2*auc(lorenz_curves_df['cum_samples'], lorenz_curves_df[measure + '_cum_claim_amount']))

gini = pd.DataFrame(data={'gini': ginis_values, 'measure': measures})

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# Write recipe outputs
ginis = dataiku.Dataset("ginis")
ginis.write_with_schema(gini)