The Claim請求頻度モデリングゾーンは、[claim_train](dataset:claim_train) でトレーニングされ、 [claim_test](dataset:claim_test)でスコアリングされたモデルで構成されます。GLM プラグインの技術的な説明については、[特定のマニュアル](https://www.dataiku.com/product/plugins/glm/)を参照してください。

![Claim Frequency Modeling.png](5YJqT1ZVX0Ja)

# 前処理

[解析](analysis:hu0snSHQ)では、まずモデル内のビジュアルスクリプトに特定のステップを追加します。 これらのスクリプトステップは準備レシピのステップと同様です。モデルをデプロイする場合、これらの初期準備ステップは、モデルがスコアリングに使用されるか、API で呼び出されるたびに計算されます。

[特徴量の処理](article:12) のステップでは以下とともにスクリプトに追加されます。

- 車両の使用年数は、VehAgeBin 変数で、年齢 0、年齢 > 0 および年齢 < 10、年齢 > 10 の 3 つのビンに分類されます。
- 運転者の年齢は、DrivAgeBin 変数でカスタムのビンに分類されます。年齢が若いほど多様な行動を示すため、小さくなっています。
- 車両のパワーは 9 までです。それよりも大きな値はあまり重要ではないからです。
- 領域は序数変数に変換され（A は 1、B は 2 など）、対数がとられます。

  # ターゲットと目標

このモデルの目的は、保険契約者が作成する請求の数である ClaimNb を予測することです。そのため、回帰の問題ではありますが、ClaimNb はポアソン変数のように分布するため、デフォルトの評価メトリクスを使用するのは最適とはいえません。そのようなメトリクスの多くは、ターゲットの分布は正規であると想定されており、異なる分布を持つ変数を取得しようとするモデル間では明確に識別されない可能性があります。そのため、カスタムメトリクスを作成してコードサンプルに保存し、他の場所で再利用できるようにします。この問題の対象となるメトリクスは、平均ポアソン偏差です。[偏差](https://en.wikipedia.org/wiki/Deviance_(statistics) は適合度のメトリクスであり、適合尤度と飽和モデルの尤度の差です。飽和モデルの尤度は、各観測に最適なポアソン適合の尤度です。偏差が小さいほど優れているとみなされます。

# 特徴量の処理

特徴量の処理では、繰り返し実験を行います。例えば、運転者の年齢を単一の数値変数として取得したり、スクリプトで作成された運転者の年齢のビンを適合させたり、カスタム前処理を通じて回帰スプラインを使用したりします。

一般には、以下の原則に従います。
- 1 つの変数を 2 回含めることはありません（ビンとして、および数値として、など）
- 変数を再スケーリングすることはありません（係数を簡単に解釈するため）
- [1 つのホットエンコーダー](https://scikit-learn.org/stable/modules/generated/sklearn.preprocessing.OneHotEncoder.html) でカテゴリー変数を処理し、ダミーを 1 つドロップします（ダミー変数間の共直線性を避けるため）

変数の組み合わせの作成は、試みたことがありません。これにより、モデルが改善される可能性はあります。

回帰スプラインを作成するために、カスタム前処理を導入し、コードサンプルに保存しました。このコードサンプルでは、以下を定義できます。
- 多項式の次数：定数の場合は 0、線形の場合は 1、二次の場合は 2、三次の場合は 3
- ノット：区分的多項式が交差するポイント
- 出力変数の接頭辞
- 「元の列を保持」のフラグ：元の列を保持する必要がある場合は、False のままにする

# モデル

アルゴリズムのリストから［Generalized Linear Model Regression］（一般化線形モデル回帰）を選び、次のオプションを選択します。
- ［Elastic Net Penalty］（エラスティックネットのペナルティ）：［0］。回帰を正則化しません。多数の変数があり、相互に共直線性を示すものがある場合、正則化によって一部の係数がゼロに縮小され、過剰適合のリスクが軽減されます。
- ［Distribution］（分布）：［Poisson］（ポアソン）
- ［Link function］（リンク関数）：［Log］（対数）。ClaimNb は正の値であるため。また、エクスポージャーを定義して、エクスポージャーごとに観測値を正規化することもできます。
- ［Offset mode］（オフセットモード）：［Offsets/Exposures］（オフセット/エクスポージャー）。エクスポージャー列を追加します。
- ［Training dataset］（トレーニングデータセット）：claim_train。解析で使用されるデータセットです。
- ［Offset］（オフセット）列：空
- ［Exposure］（エクスポージャー）列：［Exposure］（エクスポージャー）。契約が締結されていた期間の ClaimNb を正規化します。

# 結果

結果の解析は、主に［Views］（ビュー）画面の［GLM Summary View］（GLM サマリービュー）を使用して行われます。

GLM メトリクスは、モデルの適合性を評価するための 3 つの重要な指標を提供します。赤池情報量規準（AIC）とベイズ情報量規準（BIC）は、どちらも適合度とモデルに含まれる変数の数を組み合わせます。しかし、偏差は適合度の指標にすぎません。モデルに新しい変数が加えられるたびに、偏差は減少するはずです。一方、新しい変数を追加しても適合度が十分に改善されない場合は、AIC および BIC はある時点で増加します。

![GLM metrics.png](eCSYa1dofKT9)

GLM の実績と予測のグラフは、アナリストが各変数と結果の間の依存関係を視覚化するのに役立ちます。使用可能な各変数について（モデルに含まれている変数でも、含まれていない変数でも）、ビューには 3 つのグラフが表示されます。
- ［Base Graph］（ベースグラフ）は、モデル内の各変数の、実績値に対する純粋な効果を示すものであり、他のすべての変数をベース値に設定します。ベース値は、モーダル値（カテゴリー変数の場合は最も頻度の高い値、数値変数の場合は最も頻度の高いビン。数値変数は 20 の等分サイズのビンに分割される）として定義されます。
- ［Predicted Graph］（予測グラフ）は、選択した変数の各ビンにおける予測平均値を、実績値と比較したものです。
- ［Ratio Graph］（比率グラフ）は、予測値と実績値の比率を示します。

![GLM graphs.png](utaoN5vDXCDZ)