 [一般化線形モデル](article:3) の記事で説明されているように、GLM 適合では、変数と結果の間、および変数自体の間の依存関係を理解して共直線性をチェックするために、広範な特徴量エンジニアリングが必要となります。

# 単変量解析

このシンプルな解析は、考えられる各変数を 1 つずつ分析し、その分布をチェックすることを目的としています。さらに、各変数に対してターゲット変数が作成され、最終的な依存関係が示されます。数値変数の場合、これらの依存関係は線形、多項式、またはより複雑な形で表示され、依存関係は変数の定義間隔内で変化することがあります。カテゴリー変数の場合、この解析では、同様の挙動となる可能性があり再編成できるカテゴリー、あるいは十分な観測値を含んでおらず過剰適合を避けるために除外する必要がある、または他のカテゴリーとマージする必要があるカテゴリーがハイライトされます。

# 相互解析と相関

複数の変数を同時に確認すると、より複雑な依存関係が明らかになります。数値変数の場合、 [相関行列](insight:aMcJ7PU) が構築されます。高い正または負の相関（通常は絶対値で 0.5 より大きい）が確認される場合、両方の変数がモデルに含まれているときは注意が必要です。1 つの変数の情報が別の変数に含まれており、両方の変数に対して線形モデルを適合すると、不安定性や過剰適合が発生する可能性があるからです。
カテゴリー変数について相関行列を構築するのは、とくにそれらに明確な順序がない場合、簡単ではありません。そのため、結合分布をチェックすることで、あらゆる種類の変数を相互解析できます。共直線性を回避するために、1 つの変数の分布がもう 1 つの変数の分布と著しく異なる状況は避けたいところです。

# Maps（地図）

Maps（地図）では地理的な変数の視覚化を強化できます。アナリストはビジネスに関する予備知識を備えているので、直感と一致しているかどうかを簡単に見渡してチェックすることが可能です。Dataiku は、グラフ作成インターフェースに組み込まれた強力なマップグラフ作成ツールを提供しています。そのため、[このような](insight:LQcLDnQ) 視覚化を作成し、データをすばやく把握することができます。

# 回帰スプライン

前述の「単変量解析」セクションで説明したように、変数の範囲に応じて、異なる識別可能なパターンを変数が示す場合があります。[この例](insight:0jwpBNM)では、 運転者の年齢が 30 歳前のとき、年齢と請求頻度の依存関係が急激に低下していることがわかります。その後わずかに増加し、52 歳を超えるとパターンはやや不明確になります。[回帰スプライン](https://patsy.readthedocs.io/en/latest/spline-regression.html) を使用すると、境界とノットの間に多項式の依存関係を定義できます。例えば、0 度のスプラインは区分定数関数で、1 度のスプラインは区分線形関数であり、3 度のスプラインは 3 次スプラインです。

# 特徴量選択

特徴量選択は、過剰適合を避けるためのモデリングの重要な側面です。サンプルでは、GLM を適合するときに、追加される変数の数が多いほど、パフォーマンスが向上します。しかし、ある時点で、サンプル内の性能向上は単なる過剰適合が原因ということになり、サンプル外のパフォーマンス低下を引き起こします。適切な数の変数を選択するために、次のような戦略を導入できます。

- エラスティックネットの正則化：L1 および L2 ペナルティは、回帰係数に適用されます。とくに L1 は、最も有用性の低い変数の係数をゼロに縮小します。係数がゼロに縮小された特徴量は、モデリングから削除できます。
- AIC または BIC メトリクスを使用した前進的選択または後退的選択：赤池情報量規準（AIC）とベイズ情報量規準（BIC）は、適合度と、モデリングで使用される変数の数に対するペナルティを組み合わせた 2 つのメトリクスです。最初の開始時点から、変数をモデルから減らしていくことができます。これにより適合度が低下しますが、ペナルティ項も小さくなります。変数を減らすことで AIC または BIC が小さくなった場合、そのモデルは向上したとみなされます。アナリストは、メトリクスの減少が止まるまで、変数を減らしていくことができます。このアプローチは後退的選択と呼ばれます。前進的選択では最適な変数から開始し、AIC または BIC の減少が止まるまで、変数を反復的に追加していきます。

特徴量の減少手法のほかにも、特徴量選択には多くの戦略があり、最初の特徴量空間の次元数を減らし、最も影響力のあるものだけを維持することが試みられます。