Web アプリでは、モデルの予測を調べたり、各特徴量がそれらの予測に及ぼす影響を理解したり、結果を比較したりするためのインタラクティブなビューが提供されます。

特徴量は、スライダーまたはドロップダウンメニューを使用して変更できます。変更が行われるたびに API が呼び出され、予測が更新されます。密度を優先するために、領域はすべてのモデルからドロップされており、存在しません。

計算される予測は、請求頻度予測、請求程度予測、複合純保険料予測、Tweedie 純保険料予測です。これらすべての予測について、1 年間にわたるリスクを示すために、エクスポージャーを 1 に設定しています。請求程度については、1 件の請求程度を表すために、ClaimNb が 1 に設定されます。複合予測は、単純に請求頻度と請求程度の積で計算されます。

![Webapp.png](DOrZH4WIpcj1)

予測は API を使用して計算するか、フローにデプロイされたモデルから直接計算できます。 この 2 番目のオプションは、まだ API ノードにプッシュされていないモデルにアプリを使用できるようにするために用意されています。Web アプリを設定するために、［Project Variables］（プロジェクト変数）セクションで次の 2 つの変数を設定します。

- ```use_api```:フローのモデルを使用して予測を計算する場合は```"False"``` 、API を使用する場合は ```"True"``` 
- ```api_node_url```: API ノード URL。API デプロイ機能などから使用できます。

use_api が ```"False"```に設定されている場合、Python 関数を使用して予測子をインスタンス化し、予測を行います。予測子を使用して、すべてのスクリプトステップを実行できるわけではありません。予測を行う前に Python で手動により変換し、適用する必要があります。3 つの予測子のスクリプトは同一なので、特徴量が変更されるたびに Python 関数は特徴量の処理を 1 回実行し、その後、3 つすべての予測子を呼び出します。