# Business Context
For a clinical operations manager, the search for optimal trial sites is a time-consuming effort across multiple disconnected sources. While competitors are securing the best investigators, their team is stuck manually piecing together data from ClinicalTrials.gov, internal clinical trial management system (CTMS) records, and payment databases. What if you could replace this costly, weeks-long process with a single question?

Instead of having IT and analytics teams manually collect, wrangle, and precompute data for every new request, an agentic system allows business users to directly interact with their data using natural language and receive actionable insights on demand. This isn't just about efficiency; it's about empowering your domain experts to make faster, more informed decisions that can accelerate the delivery of therapies to patients.

# Case Study
## Building an Agentic Clinical Operations Assistant with Dataiku's Clinical Trial Intelligence Assistant
This solution proposed a multi-agent framework that supports dynamic queries to heterogeneous data sources and generates customizable, actionable outputs. 

### Project Background
Clinical trial planning, insights, and execution are critical to bringing new therapies to market. They are among the most costly and time-consuming components of a therapeutic product's life cycle. A clinical operations team at an industry sponsor wants to track ongoing clinical trials conducted by competitors or the broader landscape of active trials to inform their own clinical trial planning and operations effectively. They aim to establish a data-driven approach to replace the current manual site screening process for their analysts and business users.

### Initial Situation
It is crucial to recruit suitable clinical sites to meet study endpoints within the scheduled timelines. The success of a trial relies on the site investigators to recruit eligible patients and follow the study protocol. However, the ClinOps team relies on manual processes to screen or select clinical site candidates provided by third-party CROs.

This time-consuming process includes collecting and integrating study, site, and principal investigator information from multiple databases, taking an average of 4-6 weeks of analyst time per study. This delay not only costs valuable time but also risks losing top-tier investigators to competitors who can move faster.

 **Data** :
The ClinOps team has already installed Dataiku's Solutions [Clinical Site Intelligence](project:SOL_CS_INTEL) and [Social Determinants of Health](project:SOL_SDOH). Along with the public databases like [Clinicaltrial.gov](https://clinicaltrials.gov/search) and [OpenPayments](https://openpaymentsdata.cms.gov/), they plan to customize this agentic system to include data from their clinical trial management system, thereby augmenting the recruitment process for clinical sites and principal investigators. 

 **Goals** :
- Compare studies similar to a given study synopsis
- Prioritize sites from underserved communities to encourage diverse enrollment  
- Identify key principal investigators from similar studies
- Draft an alignment analysis on a principal investigator for a target clinical study
- Support business users and domain experts to create customized agents in a no-code environment. 


### The Solution
Install the Solution with Dataiku Project Setup:
 1. Retrieve insights from Clinical Site Intelligence and Social Determinant of Health Solution, and public domain data (ClinicalTrial.gov and OpenPayments API)
 2. Generate actionable insights on the fit of a key investigator for a target study. 
 
Learn more: [Project Walkthrough](article:6)
 
### Business Impact
By implementing Dataiku's Clinical Trial Intelligence Agent Solution, the ClinOps team can:
-  **Increase Productivity and Efficiency** : This solution directly replaces the 4-6 week manual data collection and analysis process with an on-demand query. A task that previously involved multiple team members (analysts, IT, ClinOps managers) and weeks of effort can now be completed in minutes by a single business user. This frees up hundreds of hours of high-skill analyst time per year to focus on high-value strategic analysis rather than low-level data wrangling.
-  **Enhance Accurate Site Enrollment** : The agent provides a unified, 360-degree view by integrating previously siloed data. Users can now ask complex, multidimensional questions, such as, "Show me PIs with experience in Phase 3 oncology trials who also have access to patient populations in zip codes identified by the SDOH solution as 'underserved' and have no conflicting payments listed in OpenPayments." This holistic view leads to more accurate enrollment predictions, supports diversity goals, and reduces the risk of selecting non-performing sites.
-  **Empower Staff with an Intergrated Workflow** : The agent acts as an intelligent "co-pilot" for the ClinOps team, empowering domain experts to self-serve insights without deep technical expertise. Instead of submitting a ticket to IT and waiting for a report, a manager can directly ask the agent to "draft an alignment analysis" for a specific investigator. The no-code environment also allows them to customize the agent's outputs, democratizing data access and fostering a data-driven culture within the business unit.


### Conclusion
With the assistance of this new agentic system, the ClinOps team can easily access clinical site insights and predict the best-ranked clinical sites to use for clinical operations, based on both the clinical feasibility of the underlying patient populations available for enrollment and historical site performance metrics. This new data-driven approach is expected to increase the success rate of meeting patient enrollment and clinical research milestones. This thereby increases the likelihood of approval, while also reducing costs for new therapeutic development. 

