# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# -*- coding: utf-8 -*-
import pandas as pd


def generate_monthly_reference_dates(max_lookback_month=12, max_date="2011-12-31"):
    # Read recipe inputs

    batch_dates = list(pd.date_range(end=max_date,periods=max_lookback_month+1, freq="MS"))
    batch_dates = [date.to_pydatetime() for date in batch_dates]
    batch_dates_df = pd.DataFrame(batch_dates, columns=["ref_date"])

    batch_dates_df["transaction_year"] = batch_dates_df["ref_date"].apply(lambda dt: dt.year)
    batch_dates_df["transaction_month"] = batch_dates_df["ref_date"].apply(lambda dt: dt.month)

    return batch_dates_df


# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
