from clv_forecast.constants import NOTRAIN_SCENARIO, RETRAIN_SCENARIO
from dku_utils.projects.project_commons import get_current_project_and_variables
from dku_utils.projects.scenarios.scenario_commons import switch_scenario_triggers_state, \
    switch_scenario_auto_trigger_state


def set_scenario_triggers():
    project, variables = get_current_project_and_variables()

    switch_scenario_triggers_state(
        project, NOTRAIN_SCENARIO, [variables["standard"]["notrain_automation_app"]]
    )
    switch_scenario_auto_trigger_state(
        project, NOTRAIN_SCENARIO, variables["standard"]["notrain_automation_app"]
    )

    switch_scenario_triggers_state(
        project, RETRAIN_SCENARIO, [variables["standard"]["retrain_automation_app"]]
    )
    switch_scenario_auto_trigger_state(
        project, RETRAIN_SCENARIO, variables["standard"]["retrain_automation_app"]
    )
