# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# -*- coding: utf-8 -*-
import pandas as pd
from datetime import datetime
from dateutil.relativedelta import relativedelta
import dataiku

from dku_utils.projects.project_commons import get_current_project_and_variables

project, variables = get_current_project_and_variables()

# Compute recipe outputs
max_date_app = variables["standard"]["max_date_app"]
sliding_lookback_window_app = variables["standard"]["sliding_lookback_window_app"]
sliding_forward_window_app = variables["standard"]["sliding_forward_window_app"]
max_lookback_month_app = variables["standard"]["max_lookback_month_app"]
best_model = variables["standard"]["best_model"]

max_date = datetime.strptime(max_date_app.split("T")[0],"%Y-%m-%d")
min_date = max_date + relativedelta(months=-max_lookback_month_app)

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
inference_metrics_df = pd.DataFrame([{
    "forward_threshold":max_date.strftime("%Y-%m-%d"),
    "sliding_lookback_window_app":sliding_lookback_window_app,
    "sliding_forward_window_app":sliding_forward_window_app,
    "max_lookback_month_app":max_lookback_month_app,
    "min_date": min_date.strftime("%Y-%m-%d"),
    "best_model": best_model
}])

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
inference_metrics = dataiku.Dataset("inference_metrics")
inference_metrics.write_with_schema(inference_metrics_df)