# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# -*- coding: utf-8 -*-
import dataiku

from clv_forecast.flow.generate_monthly_reference_dates import generate_monthly_reference_dates
from dku_utils.projects.project_commons import get_current_project_and_variables

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE

project, variables = get_current_project_and_variables()


max_lookback_month = variables["standard"]["max_lookback_month_app"]
max_date = variables["standard"]["max_date_app"]

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
monthly_granularity_df = generate_monthly_reference_dates(max_lookback_month=max_lookback_month, max_date=max_date)


# Write recipe outputs
monthly_granularity = dataiku.Dataset("monthly_granularity")
monthly_granularity.write_with_schema(monthly_granularity_df)
