This section informs you about all the requirements needed to use this solution.

# Instance Requirements
This solution is only compatible on instances with  **Dataiku V13.2+**

Once the instance is installed, the permission "May develop plugin" is needed to modify the Project Setup (but not for the flow/scenarios/dashboards)

## Code Environment
Project python recipes uses the code env **solution_clv_forecast**.
The python version used is  **3.9** 

Required packages for this code env are: 
>MarkupSafe<2.2.0
Jinja2>=2.11,<3.1
cloudpickle>=1.3,<1.6
flask>=1.0,<2.3
itsdangerous<2.1.0
lightgbm>=3.2,<3.3
scikit-learn==1.3.2
scikit-optimize>=0.7,<=0.10.1
scipy>=1.5,<1.11
statsmodels>=0.12.2,<0.14
Werkzeug<3.1
xgboost>=1.5.1,<2
tdigest>=0.5,<0.6
econml>=0.13,<0.16
pymc-marketing==0.4.2
plotly==5.23.0

# Dataset requirements
For dataset requirements see [Data Model](article:33)

Only  **transactions_history** is mandatory and should cover enough month to satisfy the backward and the forward windows.
 
 At a minimum the number of months in the history should be greater than  backward window + forward window months.
 
 For better results (to cover an entire year with training data and have a good representation of seasonality) the number of months in the history should be greater than  backward window + forward window + 12 months.
 
 
 For exemple with a backward window of 6 monts and a forward window of 3 months, **transactions_history** should cover at minimum 9 months of transactions and for better results 21 months. 