# Backward window #

from clv_forecast.constants import (
    full_backward_window_aggregation,
    full_backward_window_columns_rename,
    full_backward_window_rfm_aggregation,
)
from dku_utils.projects.project_commons import get_current_project_and_variables
from dku_utils.projects.recipes.recipe_commons import (
    get_recipe_settings_and_dictionary,
    update_recipe_ouput_schema,
)
from dku_utils.projects.recipes.window_recipe import define_window_recipe_aggregations


def full_backward_window():
    project, variables = get_current_project_and_variables()
    monthly_backward_recipe_name = "compute_monthly_granularity_full_backward"

    if variables["standard"]["leverage_rfm_segmentation_app"]:
        full_backward_window_aggregation.update(full_backward_window_rfm_aggregation)

    define_window_recipe_aggregations(
        project, monthly_backward_recipe_name, full_backward_window_aggregation
    )

    recipe_settings, _ = get_recipe_settings_and_dictionary(
        project, monthly_backward_recipe_name, False
    )

    recipe_payload = recipe_settings.get_json_payload()

    recipe_payload["outputColumnNameOverrides"] = full_backward_window_columns_rename

    recipe_settings.set_json_payload(recipe_payload)
    recipe_settings.save()
    update_recipe_ouput_schema(project, monthly_backward_recipe_name)
