import dataiku

from clv_forecast.constants import (
    classification_test_columns,
    classification_test_columns_alias,
    regression_test_columns,
    regression_test_columns_alias,
)
from dku_utils.projects.project_commons import get_current_project_and_variables
from dku_utils.projects.recipes.join_recipe import programmaticJoinHandler
from dku_utils.projects.recipes.recipe_commons import (
    adapt_recipe_engine_to_priority_and_availability,
    update_recipe_ouput_schema,
)


def join_test_data():
    project, variables = get_current_project_and_variables()
    recipe_name = "compute_test_output"

    if variables["standard"]["leverage_customer_metadata_app"]:
        rfm_dataset = dataiku.Dataset(
            variables["standard"]["customer_metadata_dataset_app"]
        )

        schema = rfm_dataset.read_schema()
        metadata_columns = list(
            filter(
                lambda name: name != "customer_id",
                map(lambda pair: pair["name"], schema),
            )
        )
    else:
        metadata_columns = []

    join_handler = programmaticJoinHandler(
        project=project,
        recipe_name=recipe_name,
        main_dataset_name="ml_data_test_classification_prepared",
        main_dataset_columns_to_select=classification_test_columns
        + metadata_columns,
        main_dataset_columns_to_select_alias=classification_test_columns_alias,
        main_dataset_computed_columns=[],
    )

    join_handler.add_one_join_on_main_dataset(
        dataset_to_join_name="ml_data_test_clustered",
        dataset_to_join_columns_to_select=regression_test_columns,
        join_type="LEFT",
        columns_prefix="",
        left_join_key=["ref_date", "customer_id"],
        right_join_key=["ref_date", "customer_id"],
        columns_to_select_alias=regression_test_columns_alias,
        dataset_computed_columns=[],
    )

    adapt_recipe_engine_to_priority_and_availability(project, recipe_name)
    update_recipe_ouput_schema(project, recipe_name)
