<span id="version" style="color: grey; float: right">Version 1.2.0</span><br/>

<span id="version" style="color: grey; float: right">Version 1.2</span>


# Customer Lifetime Value Forecasting
This project forecasts the future value of each customer using historical data and leveraging metadata and customer segmentation.

Customer Lifetime value is a crucial measure for Retail & CPG industries, equipping them with strategy optimization and understanding their future revenue. Customer Lifetime value emphasizes acquiring customers, building customer value, and retaining customers. And in turn, it gives marketers valuable insight into the effectiveness of their marketing efforts and, ultimately, their return on investment. Forecasting future customer value allows for nimbleness over different time horizons and agile adjustment to strategies.

Aggregating several sources of information for customers will improve the modeling and enable more precise identification of targets for customer actions.

## Methodology

For this solution, we build features aggregating transactions at the months-level. Some are made using the entire historical data, but we use a backward window of a customizable number of months for most. This allows us to have a common scale for customers in a recent time window.

See [Window Features Computation](article:12)

We allow this optional integration of RFM segments from the **RFM segmentation Solution** and generic customer metadata (both numerical and categorical).

Our solution aims to identify customers with similar lifetime value, enabling you to select those groups for specific marketing campaigns or to study their global behavior.

See [Value Clustering & Train/Test Split](article:14)

Regarding modelization, we perform a first step using the [Lifetimes](https://lifetimes.readthedocs.io/en/latest/) statistical model as a common feature engineering stage. We then train in parallel a classification algorithm and a regression algorithm in parallel to choose the best-performing ones according to your business needs.

See [Lifetime Statistical Prediction](article:15) and [ML prediction](article:16)

We apply the modeling to the last month of available data to estimate the future repartition of the current customers while keeping part of the historical data to validate the modeling’s performances.

# Key Outcomes

## I want to visualize the prediction for the future CLV for my current customers

![inference.png](nXHU6mSKhsSf)

Check the [Business Dashboard](dashboard:8AZNsNj)

## I want to integrate user metadata and RMF segmentation

Use the Project Setup to specify the inputs in [Connection Details](article:21)

## I want to verify the models' performances

![performances.png](Ro26bf3QNmoQ)

Check the [Data Science validation dashboard](dashboard:l8sd8aO)