# Data input Input

Landing zone to synchronize input datasets (datasets are updated from the Project Setup using scenarios. See [Data import](article:26)).


![main_input.png](laH1zDzW3Sfo)


 **transactions_history** is the main input used in the solution. It stores transactions with one line per transaction/customer/product. The only transactions taken into account are the ones before the max date parameters and for a number of month defined by the max lookback month parameter
 
 It has to match the following schema:

| Name | Description | Type | Example | Mandatory |
|---|---|---|---|---|
| transaction_id  |unique identifier for a given transaction | string  | "5846"  |  yes |
| customer_id  | unique identifier for a given customer  | string  | "12345"  |  yes |
| transaction_date  | parsed date of the transaction (at least to the day)  | date  | 2011-06-07T15:28:00.000Z | yes  |
| product_id | unique identifier for a given product | string  | “71053” | yes  |
|  quantity | number of a given item purchased in a transaction (not compatible with non countable products) | integer  | 6  | yes |
|  product_unit_price | price for an unit of product  | double  | 2.55  | yes |

The deatset used for demo is from the [UCI online retail dataset](https://archive.ics.uci.edu/ml/datasets/Online+Retail+II)


Other datasets are  **optional**  and are used to enrich the modelisation and the interpretation of the results:

![optional_input.png](p4JEXRWit2ed)

 **customer_metadata**  is a generic dataset with an unique line for each customer_id and columns for each metadata. The metadata are split into numerical metadata and categorical metadata in the Project Setup to use them in the classification and regression models.
 
 example:
 | customer_id | age | city |
 |---|---|---|
  |"12345" | 23 | Paris |
 
  **customer_rfm_segments**  is a segmentation of customers at the month level provided by the  [RFM Segmentation](https://gallery.dataiku.com/projects/SOL_RFM_SEGMENTATION/)  solution. It corresponds to the [propagation_customer_rfm_segments](https://gallery.dataiku.com/projects/SOL_RFM_SEGMENTATION/datasets/propagation_customer_rfm_segments/explore/) dataset.



