<span id="version" style="color: grey; float: right">Version 1.1.0</span>

# Credit Risk Stress Testing

Credit Risk Portfolio Modeling is necessary for risk, regulatory and accounting purposes in banking institutions. Credit Risk is the most prevalent risk in banks, therefore it must be monitored carefully. They also involve large amount of data that are funnelled though complex transformation and modeling phases to obtain final risk figures.

## Regulations (CECL, IFRS9)

In the United States, CECL or Current Expected Credit Losses is a new method used among companies that follow the Generally Acceptable Accounting Principles (GAAP). CECL's objective revolves around estimating allowances for credit losses issued by the Financial Accounting Standards Board (FASB).

The CECL methodology requires companies to have a proactive approach to calculate credit losses and be able to record an impairment or deduction to their revenues as a result of potential losses. Typically, risk managers are involved in creating the models behind CECL calculations, and accountants are involved in the process of calculating and/or approving the final estimated loss value.

IFRS9 stands for International Financial Reporting Standard 9. Similarly to CECL, it requires credit instruments to be fairly valued, which involves computing the Expected Credit Losses (ECL).

## Stress Testing

Stress Testing encapsulate more ad hoc analysis that aim at capturing the bank's credit risks linked to adverse macroeconomic shocks. These analysis could be carried out at a discretionary level by the bank to improve their reliability or be ordered by a regulatory body such as the Central Bank. They might include more complex hypothesis to take into account future additions to the existing credit portfolios.

# Key Outcomes

- Collaboration with guardrails: Each credit portfolio can be evaluated and adjusted independently, using a shared foundational design with customization as needed, while flexible applications allow users to interact with only those components of the workflow relevant to their role.
![Outcome 1.png](63b2wELCvVFK)
- Data quality reviews at every step and level: Data quality checks can be executed independently by portfolio and data workflow stage, ensuring data issues or adjustments can be isolated and tackled efficiently while providing complete oversight and review before final sign-off.
![Outcome 2.png](JIVQWiWrbuWp)
- Powerful visualizations: Built-in waterfall charts, topline calculations, and adjustment summaries simplify analysis and review.
![Outcome 3.png](VMlbBsvTxdOU)