The objective of Loss Given Default (LGD) modeling is to quantify the portion of a collateralized asset that a bank can expect to recover in the event of a borrower default. For example, consider a mortgage scenario where, in the event of default, the property is sold, and the proceeds are utilized to repay the loan. However, if the outstanding loan balance exceeds the property's value, the bank incurs losses. The LGD model is specifically designed to estimate and account for this ultimate loss, providing a critical tool for risk assessment and mitigation within the lending process.

# Loan-to-Value

Loan-to-Value (LTV) is a metric often followed to understand the LGD risk of loan, is computed as:

```math
LTV = \frac{Loan Amount}{Asset Value}
```

This ratio assumes a central role during the loan origination process, serving as a critical indicator of credit risk. Given that loans are often secured by underlying assets, the bank's ability to recover its funds hinges on the asset's sale in the event of borrower default. At the loan's inception, the LTV is typically less than one because the loan amount finances only a fraction of the asset's total value. Over time, this value may fluctuate, especially during economic downturns. For instance, if the LTV stands at 80%, a decline of more than 20% in the asset's value could result in losses for the creditor. In contrast, a lower LTV of 20% would necessitate an asset value drop exceeding 80% before the creditor faces losses, rendering the loan substantially safer. Additionally, as borrowers gradually repay the principal, the LTV diminishes, further reducing the risk of default.

# Peak-to-Trough

The Peak-to-Trough modeling approach for Loss Given Default (LGD) represents a conservative strategy that delves into historical worst-case scenarios for asset value declines. This method involves calculating the most significant difference between consecutive peaks and troughs in asset values. This approach is particularly pertinent as defaults often tend to spike during these trough periods. These calculations can be performed on multiple levels, including geographical and asset class considerations. For instance, in the context of mortgages, assets can be further categorized into various subgroups like houses and flats, urban and rural properties, etc. In this project, we focused on housing prices at the state level in the United States, revealing significant variations in Peak-to-Trough ratios among different states, as illustrated in the graph below.

![House Prices Indices.png](tzw2FfQsGtCF)