The implementation of CECL, IFRS9, or Stress Testing for various purposes typically involves a highly intricate process, as these models necessitate training and execution for each individual credit portfolio within the institution. Often, there are numerous such portfolios, ranging from tens to hundreds, that must undergo this process in each iteration. Moreover, these models are dynamic, evolving over time, and the computation of Expected Credit Loss (ECL) must be conducted regularly, usually on a quarterly basis. This routine computation significantly impacts the bank's balance sheet. Consequently, these models are subject to rigorous scrutiny from auditors and regulators alike, demanding a robust historical record and audit trail to comprehensively understand what transpired in the past and which model was employed during each assessment period.

To account for this complexity, we propose here an architecture that can support the full process.

# Architecture Proposal

The project presented here offers a comprehensive template encompassing both modeling and execution phases, recognizing that these phases are often separated in practical implementation. The modeling phase typically involves historical data and is typically managed by a distinct team. Approved models can be stored as Dataiku Models, MLFlow models, or even as Python functions, all of which can be effectively version-controlled.

Once the models are prepared, the execution architecture for a specific iteration involves an orchestration project linked to multiple ECL projects, with one dedicated to each portfolio. Data quality checks can be executed either at the orchestration level or within individual portfolio projects, depending on how different are the data model for each portfolio. Within each individual portfolio project, data undergoes processing through the models to derive ECL results. The orchestration project serves as the control center, launching and monitoring the execution, and subsequently aggregating all ECL results to generate the final report. Individual portfolio projects can be spun up from existing ones, facilitating experimentation or other needs from the orchestration project.

After the completion of a run, the entire iteration can be preserved using Dataiku's [bundling capability](https://doc.dataiku.com/dss/latest/deployment/index.html). These bundles encapsulate the project configuration along with selected datasets and models, and can be deployed on an automation node to save them as golden copies.

A master orchestration project assumes oversight of all iterations, enabling the creation of new iterations based on existing ones, ensuring a systematic and streamlined approach to the entire process.