# -*- coding: utf-8 -*-
import dataiku
import pandas as pd, numpy as np
from dataiku import pandasutils as pdu

# Read recipe inputs
applications_filtered_sensitive = dataiku.Dataset("applications_filtered_sensitive")
applications_filtered_sensitive_df = applications_filtered_sensitive.get_dataframe()
applications_sensitive_variable_analysis = dataiku.Dataset("applications_sensitive_variable_analysis")
applications_sensitive_variable_analysis_df = applications_sensitive_variable_analysis.get_dataframe()

top_proxy = applications_sensitive_variable_analysis_df[applications_sensitive_variable_analysis_df['information_value']==max(applications_sensitive_variable_analysis_df['information_value'])]['feature'].iloc[0]

applications_proxy_analysis_df = applications_filtered_sensitive_df[['sensitive_variable', top_proxy]]
applications_proxy_analysis_df.columns = ['sensitive_variable', 'proxy']

# Write recipe outputs
applications_proxy_analysis = dataiku.Dataset("applications_proxy_analysis")
applications_proxy_analysis.write_with_schema(applications_proxy_analysis_df)
