# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
#%config Completer.use_jedi = False

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# -*- coding: utf-8 -*-
import dataiku
import pandas as pd, numpy as np
from dataiku import pandasutils as pdu

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
project_key = dataiku.get_custom_variables()["projectKey"]
client = dataiku.api_client()
project = client.get_project(project_key)

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
saved_model = project.get_saved_model('ujHt1cz4')

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
model_details = saved_model.get_version_details(saved_model.get_active_version()['id'])

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
coefs = model_details.get_raw()['iperf']['lmCoefficients']
variables_coefs = {coefs['variables'][i]: coefs['coefs'][i] for i in range(len(coefs['variables']))}

variables = list(variables_coefs.keys())
coefs_list = list(variables_coefs.values())

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
coefficients = pd.DataFrame({'variable': variables, 'coefficient': coefs_list})
coefficients['intercept'] = coefs['interceptCoef']

# Write recipe outputs
model_coefficients = dataiku.Dataset("model_coefficients")
model_coefficients.write_with_schema(coefficients)