The Credit Model zone is where the Logistic Regression is built on the selected features. Then the scorecard is created directly from the regression coefficients. More complete details about these steps are available [here](article:10).

![Credit Model.png](CPdgziBqGP3x)

First, sensitive variables are joined back to the applications dataset. Sensitive variables will not be used to build the model, but having them available in the dataset used to train the model allows the user to run subpopulation analysis on the model to check for biases.

Then the [Logistic Regression](saved_model:ujHt1cz4) is trained on the data. Only actual features are kept in features handling, sensitive variables and the id column are rejected. Since features are already encoded with the weight of evidence, features should be input as is and not rescaled. The selected algorithm is a Generalized Linear Model with 0 penalties, the Binomial distribution, and the logit link function, also known as Logistic Regression. The hyperparameter search metric and threshold optimization metric are not important since there is no hyperparameter and the threshold will not be used in the rest of the project.

The regression coefficients are extracted from the model in the next [python recipe](recipe:compute_score_card) and outputted in a dataset with the intercept. In the upper branch, clean numeric and categorical bins are stacked together, and similar fields are regrouped such as label, variable, and woe, while the other fields are either specific to numeric variables or to categorical variables. The [join recipe](recipe:compute_woe_bins_coefficients) assigns the model coefficients to each variable to enable to build of the scorecard.

Using the formula defined in the article linked at the top, the score is computed for each bin of each variable in a [prepare recipe](recipe:compute_score_card_1). Since some variables have been removed with the feature selection after the bins were created, some of the rows are unnecessary so they are deleted. Finally, in the [grouping recipe](recipe:compute_score_card_simple), data is shrunk to its most compact format.



