The Responsible Credit Scoring zone focuses on some specific fairness aspects of the data with respect to Credit Scoring. More details about these considerations can be found [here](article:3).

![Responsible Credit Scoring.png](EYHoREV2K8cg)

The initial [prepare recipe](recipe:compute_applications_sensitive_variables) just keeps the sensitive variables along with the id variable. Then the next [windows recipe](recipe:compute_applications_sensitive_variables_windows) and [prepare recipe](recipe:compute_applications_sensitive_variables_prepared) are meant to turn the sensitive variables that are numeric into categorical by simply creating a category for the above average, and one for the under average. After this transformation is done, the [join recipe](recipe:compute_applications_filtered_sensitive) adds the credit event variables and the other variables that have already gone through the first filtering. At the end of the recipe, the selected sensitive variable is renamed as ```sensitive_variable``` to focus on it in the following steps.

On the [applications_filtered_sensitive](dataset:applications_filtered_sensitive) dataset, some tests are run with respect to the ```sensitive_variable```, they are explained in the [dashboard](article:31).

Then, the information value is computed between the sensitive variable and the other variables to detect if any of them could be a proxy through a [python recipe](recipe:compute_applications_entropy_1). The final [python recipe](recipe:compute_applications_proxy_analysis) retrieves the top proxy in terms of information value to build a dataset containing only that proxy and the selected sensitive variable. In the output dataset, the test is run to check if both variables are independent.


