The webapp provides an interactive experience to navigate the scorecard. Access it by clicking this [link](web_app:Jm7PgpJ).

![Webapp.png](qdnLOwlqCpis)

The webapp is built from the scorecard created in the project. This [scenario](scenario:UPDATEWEBAPPANDAPI) creates all the necessary data for the webapp to be updated and working properly. The webapp will adapt to the number and type of features selected in the project. Users can modify input values on the left-hand side panel and visualize the results on the main screen. The Dataiku Solutions button on the top-left corner gives an overall description of the webapp.

# Features

![Features.png](aFs7c2wpWaGh)

All features are listed in order of importance according to the scorecard. The importance is computed as the maximum possible score minus the minimum possible score to assess how significantly the variable can sway the score on one side or the other.

Features can be either numeric or categorical. The sliders enable the modification of numeric variables; they also come with a checkbox to deactivate these variables meaning that the value is missing. To select categorical variables, a dropdown lists all the possible values for the user to choose. Feature ranges for numeric variables and all possible values for categorical variables are computed in the [feature_ranges_label](dataset:feature_ranges_label) dataset.

# Score

![Score.png](YSv9WEGkhZPA)

The scorecard was built using the parameters defined in the [Dataiku Application](article:15). The coloring of the gauge and qualification of the score are automatically deduced from them as follows:

```
if score < base_points:
        color = red, rating = Bad
else if base_points < score < base_points + points_to_double_odds:
        color = orange, rating = Fair
else:
        color = green, rating = Good
```

The description beside the score is based on the rating obtained and indicates the bad rate computed using the [scores_binned](dataset:scores_binned) dataset.

If the ```use_api``` option is deactivated, the score is computed in the webapp backend by loading the API folders: [credit_performance_api](managed_folder:j1Y0d8qF) and [score_card_api](managed_folder:SAYeRY7R). The webapp calls the API, which computes and outputs the score.

# Cards

![Cards.png](FfIkZMjpXxDU)

For each variable, a card shows all the possible buckets a value can belong to and their corresponding number of points. The final score will be the sum of the points from each variable. Hence, depending on the number of points attributed to a variable, it might contribute positively or negatively to the final score. The coloring and top gauge of the card reflects this contribution. They are defined in this [prepare recipe](recipe:compute_score_card_1) according to the same logic as the overall score.


