This final slide focuses on the Responsible Credit Scoring aspect of the project, following the Responsible AI (RAI) framework. This broader perspective is discussed in the previous dedicated [article](article:3). The slide is divided into three parts described below. All the analysis refers to one sensitive variable which has been selected by the user in the [Dataiku Application](article:15).

![RAI Bias.png](gWb9oLyHPyRP)

Two tests are run to check if the data and especially the credit event variable is related to the selected sensitive variable. The t-test checks if the means of the credit event frequency within each of the sensitive variable buckets are the same. If not, the analyst might consider digging deeper to understand why they differ and if the handling of the data should take this information into account. Similarly, the two variables, the sensitive variable, and the credit event variable are tested for independence and should yield the same conclusions as the previous test.

![RAI Proxy.png](CcyhTdHlKLvI)

Sensitive variables are eliminated from the dataset to build the model, but some other variables that could seem at first glance non-sensitive could serve as proxies for these sensitive variables. Here the first graph computes the information value between all the variables and the sensitive variable. Variables that have high values of information value could serve as proxies and should be handled with care. The subsequent test looks at the independence between the sensitive variable and the top proxy, if both variables are not independent, some information about the sensitive variable can be inferred from the proxy.

![RAI Subpopulation Analysis.png](vhVl3F99OZKF)

The final section analyzes the model with respect to the sensitive variable. Subpopulation analysis splits model metrics between the different values of the sensitive variable to check if some significant discrepancies arise on some of them.


