from flask import Blueprint, jsonify, request
from webaiku.apis.dataiku.api import dataiku_api
from .csi import study_similarity, StudySimilarity, SiteScoreCard, study_neighbors
from .models import UIOptions
from .models import NovelStudy, SiteScoreCardPostRequest

fetch_api = Blueprint("fetch_api", __name__, url_prefix="/api")


@fetch_api.route("/studies/ui_options", methods=["GET"])
def get_ui_options():
    return jsonify(
        UIOptions(
            meshTerms=study_similarity.meshTerms_values,
            ntcids=study_similarity.nctids,
            cohortAges=study_similarity.cohort_age_values,
            cohortSexes=study_similarity.cohort_sex_values,
        )
    )


@fetch_api.route("/studies/summary/<id>")
def get_study_summary(id: str):
    return jsonify(StudySimilarity.get_study_summary(id))


@fetch_api.route("/study/novel/similar", methods=["POST"])
def get_novel_similar_studies_and_sites():
    ## Extract payload
    data: NovelStudy = request.get_json()
    ## Return similar
    return jsonify(study_neighbors.get_nearest_studies_and_sites_w_scores(data))
    # return jsonify(test_data)


@fetch_api.route("/study/similar/<id>", methods=["GET"])
def get_existing_similar_studies(id: str):
    return jsonify(study_neighbors.get_nearest_studies_and_sites_w_scores(id))
    # return jsonify(test_data)


@fetch_api.route("/site/score_card", methods=["POST"])
def get_site_score_card():
    data: SiteScoreCardPostRequest = request.get_json()
    return jsonify(SiteScoreCard.get_site_scorecard_json(data["siteId"]))
