from typing import List
import pandas as pd
import json
import string

import pwd
import os
import re


def get_keys_from_typed_dict(typed_dict_class: type) -> List[str]:
    return list(typed_dict_class.__annotations__.keys())


def is_empty_df(df: pd.DataFrame):
    return df.empty


def df_to_dict(df: pd.DataFrame, keep_first: bool = True):
    if is_empty_df(df):
        return None
    if keep_first:
        result = df.iloc[0]  ## Pandas Series
        return json.loads(result.to_json())
    else:
        result = df
        return json.loads(result.to_json(orient="records"))


def transform_string(input_string: str):
    lowercased_string = input_string.lower()
    trimmed_string = lowercased_string.strip()
    final_string = re.sub(r"\s+", "_", trimmed_string)
    return final_string
