import { StudyKnownStatus, StudyEnrollmentRate } from "@/models"

export const studyStatusColorMapping: Record<string, { color: string; textColor: string }> = {
    [StudyKnownStatus.ACTIVE_NOT_RECRUITING]: { color: "#00B257", textColor: "#FFF" },
    [StudyKnownStatus.COMPLETED]: { color: "#00B257", textColor: "#FFF" },
    [StudyKnownStatus.NOT_YET_RECRUITING]: { color: "#D4443C", textColor: "#FFF" },
    [StudyKnownStatus.RECRUITING]: { color: "#D4443C", textColor: "#FFF" },
}

export const studyEnrollmentRateColorMapping: Record<string, { color: string; textColor: string }> = {
    [StudyEnrollmentRate.High]: { color: "#00B257", textColor: "#FFF" },
    [StudyEnrollmentRate.Low]: { color: "#D4443C", textColor: "#FFF" },
    [StudyEnrollmentRate.Medium]: { color: "#F89412", textColor: "#FFF" },
}
export const defaultBadgeColor = { color: "#A0A0A0", textColor: "#FFF" }


export function getEnrollementRateColors(rate: string | StudyEnrollmentRate) {
    if (studyEnrollmentRateColorMapping[rate] != null) {
        return studyEnrollmentRateColorMapping[rate]
    }
    return defaultBadgeColor;
}