import { StudySite, NovelStudy, CandidateSite } from "./backend";


export const NovelStudyInitData: NovelStudy = {
    title: null,
    briefSummary: null,
    cohortAge: [],
    cohortSex: null,
    healthyVolunteers: false,
    inclusionCriteria: null,
    exclusionCriteria: null,
    meshConditions: []
}

export enum StudyKnownStatus {
    RECRUITING = "RECRUITING",
    COMPLETED = "COMPLETED",
    ACTIVE_NOT_RECRUITING = "ACTIVE_NOT_RECRUITING",
    NOT_YET_RECRUITING = "NOT_YET_RECRUITING"
}

export enum StudyEnrollmentRate {
    Low = "Low",
    Medium = "Medium",
    High = "High",
}

export type GroupableSites = Record<string, { label: string; children: Record<string, { label: string; data: Partial<StudySite>[] }> }>;

export type GroupableCandidateSites = Record<string, { label: string; children: Record<string, { label: string; data: Partial<CandidateSite>[] }> }>;


export enum MultiSelectType {
    Checkbox, MultiSelect
}

export interface MultiSelectUI {
    key: string;
    type: MultiSelectType;
    options: string[];
    label: string;
}

export const similarStudiesFilteringKeys = [
    { key: 'Rank', label: 'similarities_score', type: MultiSelectType.MultiSelect },
    { key: 'Study_status', label: 'study_status', type: MultiSelectType.Checkbox },
    { key: 'Enrolment_rate_combined', label: 'enrolment_rate', type: MultiSelectType.Checkbox },
    { key: 'MeshTerm_Conditions', label: 'condition', type: MultiSelectType.MultiSelect },
    { key: 'Phase', label: 'study_phase', type: MultiSelectType.MultiSelect }
]

export const candidateSitesFilteringKeys = [
    { key: 'Has_competing_studies', label: 'has_competing_studies', type: MultiSelectType.Checkbox },
    { key: 'Country', label: 'selected_countries', type: MultiSelectType.MultiSelect },
    { key: 'Region_State', label: 'region_or_state', type: MultiSelectType.MultiSelect },
    { key: 'City', label: 'cities', type: MultiSelectType.MultiSelect }
]