# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# -*- coding: utf-8 -*-
import dataiku
import pandas as pd, numpy as np
from dataiku import pandasutils as pdu

# Read recipe inputs
eligibilities = dataiku.Dataset("eligibilities_distinct")
eligibilities_df = eligibilities.get_dataframe()

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
def convert_to_years(time_str):
    value, unit = time_str.split()
    value = float(value)
    if unit in ['Years', 'Year']:
        return value
    elif unit in ['Months', 'Month']:
        return value / 12
    elif unit in ['Weeks', 'Week']:
        return value / 52
    elif unit in ['Days', 'Day']:
        return value / 365
    elif unit in ['Hours', 'Hour']:
        return value / 8760
    elif unit in ['Minutes', 'Minute']:
        return value / 525600
    else:
        raise ValueError(f"Invalid unit: {unit}")

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
eligibilities_df['MaximumAge'] = (
    eligibilities_df['MaximumAge']
    .apply(lambda x: convert_to_years(x) if isinstance(x, str) else np.nan))

eligibilities_df['MinimumAge'] = (
    eligibilities_df['MinimumAge']
    .apply(lambda x: convert_to_years(x) if isinstance(x, str) else np.nan))

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# Write recipe outputs
eligibilities_prepared = dataiku.Dataset("eligibilities_prepared")
eligibilities_prepared.write_with_schema(eligibilities_df)