The Sponsor Insights Dashboard provides an overview of clinical trials and clinical research sites sponsored by a selected lead sponsor. The dashboard has two versions, depending on the Dataiku Application configuration: [Sponsor Insights with SDOH](dashboard: KjMTgA5) if the setting includes the SDOH dataset option and [Sponsor Insights](dashboard:ui8AOjN) otherwise.

 1. Studies Overview
 2. Clinical Sites Overview
 3. Census Social Factors and CDC Chronic Disease Prevalences at Site Locations
 
 <div class="alert">
"Sponsor Insights with SDOH" has three slides while "Sponsor Insights" has only the first two slides. 
</div>

# Studies Overview
The first slide provides the most up-to-date information from the clinicaltrials.gov dataset. This solution augments the intelligence with study enrollment rate prediction for ongoing studies. This section has two parts: study enrollment rate prediction and study characteristics.
## Study Enrollment Rate Prediction
![Screenshot 2023-10-12 at 09.11.03.png](wXmwquofjeUO)
The **study enrollment rate** is the enrollment count divided by the study period (from start to completion). Then, we categorize it into three buckets: **High**,  **Medium**, and **Low**. **High** represents an enrollment rate of more than 100 patients annually. **Medium** 25 to 100 per year. **Low** fewer than 25 per year. **NA** represents studies with zero enrollment.
The study enrollment rate prediction model only predicts ongoing studies and demonstrates its result in the **ESTIMATED** subplot. The **ACTUAL** subplot shows the actual enrollment rate of the completed studies  (with enrollment type "Actual"). [Read documentation](article:30) to learn more about the enrollment rate prediction model.

The tables of study summary list the studies with their respective enrollment rate. 


## Study Characteristics
![Screenshot 2023-10-12 at 09.49.38.png](gjDhAkl3EamM)
The four plots represent the enrollment status, study phases,  percentage of studies in the therapeutic area, and intervention domain. 


# Clinical Sites Overview
This slide summarizes broader study activity and history across sponsors sourced from clinicaltrials.gov at clinical sites used by the selected sponsor of interest.

**Clinical Sites Harmonization**

<div class="alert">
  The Clinicaltrial.gov dataset is a study registry whose data schema follows a study-oriented convention. Clinical research sites associated with the studies are stored as free text without unique identifiers. It requires a data pipeline with advanced analytics to harmonize clinical sites and assign site IDs to each entity before performing meaningful analytics. 

</div> 

Please read the documentation for details on the [sites harmonization pipeline](article:18)

This slide has two parts: the geography of clinical research sites & competing studies and sponsors.


## Clinical Research Sites Geography
![Screenshot 2023-10-12 at 11.17.26.png](nyvPbZMOEU8p)
The Site map presents the cities where the clinical sites are sponsored. The geolocation information is limited to the city level on clinicaltrial.gov. Therefore, the map displays the count of research sites and competing sponsors for each city a selected sponsor uses. The Table of **Clinical Sites Used** lists the Site ID, name, geolocation, count of studies involved, and the number of sponsors involved.

## Competing Studies and Sponsors
![Screenshot 2023-10-12 at 11.17.52.png](CggjY8TMrikj)
The charts give an overview of the number of competing studies and sponsors on the clinical sites used by the selected sponsor of interest. The **Top Sites Used by Competing Sponsors and Study Status** shows the clinical sites' records of involvement in other studies sponsored by other lead sponsors. The **Top Sponsors Using Clinical Sites by Study Status** indicates the number of clinical sites that a given lead sponsor competes against the selected sponsor.


# Social Determinants of Health on Sites
The last slide reveals the locations of facilities (sites) used for studies by the selected sponsor with CENSUS county populations and Social Vulnerability information. It is only available if the SDOH dataset is included during the build-up in the Dataiku application. The current version is limited to the USA census data.
![Screenshot 2023-10-12 at 12.03.38.png](6nkKVZKlyCXh)