## Business Context
Clinical operations refer to the tasks involved in planning and executing clinical trials, from design to completion. Clinical Operation (ClinOps) Teams manage these tasks and coordinate with various internal and external teams to facilitate the clinical trial process in accordance with the study protocol and best practices. Selecting suitable clinical sites that meet planned patient recruitment goals is essential for the success of clinical trials. An estimated 55% of trials fail due to low patient accrual rates, and more than 80% fail to enroll in time, leading to study extension (past planned milestones), need for new study sites, and costly protocol amendments.


## Case Study: Facilitate Clinical Site Selection for ClinOps Team Using Dataiku's Clinical Site Intelligence Solution
This Solution aims to support clinical operation (ClinOps) teams in making informed decisions in study planning and site selection based on historical site performance and competitive intelligence for a given study synopsis. 


### Project Background
The ClinOps team at a leading pharmaceutical company manages clinical trials for novel molecules in cancer treatment. They seek to establish a data-driven approach to inform clinical site selection during study planning and implementation. By leveraging Dataiku's Clinical Site Intelligence Solution, the ClinOps team can make informed decisions based on site performance and sponsor competitiveness analysis. The augmentation of social vulnerability insights from Dataiku's Social Determinants of Health Solution supports the ClinOps team in expanding their patient participation by identifying sites that provide trial access to diverse and potentially under-represented communities. 

### Initial Situation
 **Current workflow and challenge:** 
 - Internal and external clinical operational databases provide a limited view of trials, site performance, and availability.
 - Manual process to search and compare similar studies
 - Desire to promote sites in under-represented communities to diversify enrollment
 - Difficult to ensure sites have the proper experience, training and capacity aligned to protocol goals

**Data:** 
To address these challenges, the ClinOps team integrates several data sources:
- [ClinicalTrials.gov](https://clinicaltrials.gov/about-site/about-ctg): global clinical trial registry 
- Social Vulnerability Index (SVI): US Census data on socio-economic factors that impact health, including income, employment, education, housing, and access to healthcare.
- Community Demographics: Census demographic data contextualizes social vulnerability, allowing a deeper understanding of each community's characteristics.

**Goals:** 
- Extract quality insights from ClinicalTrials.gov: query and process registered studies to create in-depth individual site review analytics and export potential site lists 
- Prioritize experienced sites: learn from other sponsors' activities, find sites capable of executing studies designed similar to theirs
- Identify under-represented communities: discover site patterns and align SDOH factors around site geos to encourage diverse enrollment
- Understand the competitive landscape around sponsor and site utilization 


### Insights and Analytics
The Solution leverages rich information from ClinicalTrial.gov (CT.gov) and US census data to generate insights into similar studies and associated clinical sites. The Clinical Site Intelligence Webapp and Sponsor Dashboard provide an interactive interface to visualize insights on study enrollment predictions, study similarity analysis, and clinical site utility across the landscape of different studies and sponsors.

 **Setup the Solution with Dataiku Application:** 
The Solution offers an accessible setup for making custom queries to CT.gov API, extracting crucial information for studies of interest, and including SDOH insights.
![solution_csi-dku-apps.png](tdxetfkmVmJ3)

#### Study Similarity and Site Discovery
The Clinical Site Intelligence Web app provides a no-code interactive interface to generate insights on clinical sites for a given study synopsis, accelerating clinical site selection. The ClinOps team can enter a novel study synopsis, explore similar studies, and identify the associated clinical sites through trial characteristics, enrollment rate prediction, and competitiveness intelligence.
![solution_csi-webapp-study_similarity.png](NeDQKOOe1Kr4)
![solution_csi-webapp-associated-sites.png](hWA40qVFMU44)

#### Site Review and Social Vulnerability
The  **Site Card**  from the **Clinical Site Intelligence Webapp** further offers individual site insights into sponsor activities and social vulnerability factors. It shows the Social Vulnerability Scores and the 16 social demographic factors of the community where the site serves. It also visualizes the history and characteristics of the study and sponsor activities. Thus, the ClinOps team can ensure the sites have the potential resources and operational quality for the success of trial outcomes. 
![solution_csi-webapp-site-cards-sdoh.png](kVwtm9OrNVIt)
![solution_csi-webapp-site-cards-history.png](wGPOXpVOQRnD)

#### Comprehensive Sponsor insights
The **Sponsor Dashboard** sheds light on studies and associated clinical sites with competitive intelligence of site utilization by other sponsors and SDOH. The ClinOps team lead can have an overview of the historical and current trials sponsored by their company to understand the sites (site networks) and regions they have worked with and the study criteria, interventions, conditions, outcomes, and enrollment rate success in just a few clicks.
![solution_csi-dashboard-site-overview.png](RorZZVTn19Fs)
![solution_csi-dashboard-sdoh.png](dJjT4FByWIWs)


### Business Impact
By implementing Dataiku's Clinical Site Intelligence Solution, the ClinOps Team can:
- Create a dynamic pipeline to query the most relevant and up-to-date data from the CT.gov database for its business needs
- Adopt a data-driven approach to discover clinical sites capable of executing similar studies
- Promote suitable sites that encourage diverse enrollment

### Conclusion
With Dataiku's Clinical Site Intelligence Solution, the ClinOps Team has transformed its approach to the clinical site selection process from a highly manual workflow to a targeted, data-driven strategy. By integrating real-time trials and social data, this Solution empowers the team to inform site selection strategy and encourage inclusiveness and diversity of study enrollment.