Scenarios allow for automating the flow computation and are triggered through the [Dataiku Application](article:43).

### Scenario supporting Connection Configuration
![scenario-connection.png](OWpkYHEbunm8)
 **Main Scenario** 
  - [\[CSI\] Connection reconfiguration](scenario:CSIRECONFIGUREINPUTS): changes datasets and folders connection.
  
### Scenario supporting Complete Pipeline
![scenario-pipeline.png](VG3WQJbGkadz)
 **Main Scenario** 
 - [\[CSI\] Complete pipeline](scenario:CSSCOMPLETEPIPELINE): create a study datasets based on a custom ct.gov API query, retrain the study recruitment rate model, retrain the study similarity index, and populate datasets supporting the web app and dashboard.
 
**Supporting Scenario**
 - [\[CSI\] Query CTGOV API](scenario:SELECTSTUDIESFORANALYSIS): make a custom query to ct.gov API and save the result in [clinicaltrialgov_dataset](dataset:clinicaltrialgov_dataset)
 - [\[CSI\] Pipeline: External Source](scenario:CSIPIPELINEEXTERNALSOURCE): load and transform external datasets
 - [\[CSI\] Pipeline: Extract tables](scenario:[CSS]_Pipeline__Extract_tables): create function tables
 - [\[CSI\] Pipeline: Mesh terms preparation](scenario:MESHTERMSPREPARATION): create condition and intervention Mesh labels
 - [\[CSI\] Pipeline: Clinical sites preparation](scenario:CLINICALSITESPREPARATION): harmonize clinical site name variation
 - [\[CSI\] Pipeline: Features preparation](scenario:[CSS]_Pipeline__Features_preparation): extract features for the study enrollment prediction model and study similarity index
 - [\[CSI\] Pipeline: US Census SDOH features](scenario:USCENSUSSDOHFEATURES): prepare US SDOH features
 - [\[CSI\] Pipeline: Enrollment rate model feature engineering](scenario:ENROLMENTRATEMODELFEATUREENGINEERING): prepare features for the study enrollment prediction model
 - [\[CSI\] Pipeline: Study similarity model feature engineering](scenario:STUDYSIMILARITYMODELFEATUREENGINEERING): prepare features for study similarity index
 - [\[CSI\] Model: Build enrollment rate model with SDOH features](scenario:CSSBUILDENROLMENTRATEMODELWITHSDOHFEATURES): retrain study enrollment prediction model with SDOH features
 - [\[CSI\] Model: Build enrollment rate model](scenario:BUILDENROLMENTRATEMODEL): retrain study enrollment prediction model 
 - [\[CSI\] Model: Build similarity index](scenario:BUILDSIMILARITYINDEX): retrain study similarity index
 - [\[CSI\] Pipeline: Clinical site insights precompute](scenario:CCSPIPELINECLINICALSITEINSIGHTSPRECOMPUTE): populate datasets supporting the Webapp
 [\[CSI\] Pipeline: Study similarity & sites selection precompute](scenario:CSSPIPELINESTUDYSIMILARITYSITESSELECTIONPRECOMPUTE): populate datasets supporting the Webapp
 
## Scenario supporting Dashboarding
![scenario-dashboard.png](uixfrIB1K3ng)
 **Main Scenario** 
 - [\[CSI\] Dashboard: Sponsor insight](scenario:DASHBOARDSPONSORSITESINSIGHT): create dashboard
 - [\[CSI\] Dashboard: Sponsor insight with SDOH](scenario:CCSDASHBOARDSPONSORINSIGHTWITHSDOH): create dashboard

**Supporting Scenario**
[Compute Metrics](scenario:COMPUTEMETRICS): regenerate metrics