This section informs you about all the requirements needed to use this solution.

# Instance Requirements
This solution is only compatible on instances with  **Dataiku V12.6+**

## Code Environment
Project python recipes uses the code env **solution-customer_satisfaction_reviews**.
The python version used is  **3.9** 

Required packages for this code env are: 
>MarkupSafe<2.1.0
Jinja2>=2.11,<2.12
cloudpickle==3.0.0
flask>=1.0,<1.1
itsdangerous<2.1.0
lightgbm>=3.2,<3.3
scikit-learn>=1.0,<1.1
scikit-optimize>=0.7,<0.10
scipy==1.13.0
statsmodels==0.12.2
xgboost==0.82
gluonts>=0.8.1,<=0.10.4
pmdarima>=1.2.1,<1.8.5
mxnet==1.8.0.post0
prophet==1.1.1
holidays>=0.14.2,<0.25
transformers==4.39.3
sentencepiece==0.2.0
torch==2.2.2
Werkzeug==2.1.2


## NLP model import
Preloading the NLP model while creating the code environment for some configurations might be necessary. It is done by the following Initialization script in the Resources tab of the code environment definition:

```
## Base imports
from dataiku.code_env_resources import clear_all_env_vars
from dataiku.code_env_resources import set_env_path
from dataiku.code_env_resources import set_env_var

# Clears all environment variables defined by previously run script
clear_all_env_vars()

## Hugging Face
# Set HuggingFace cache directory
set_env_path("HF_HOME", "huggingface")


# Load model directly
from transformers import AutoTokenizer, AutoModelForSequenceClassification

tokenizer = AutoTokenizer.from_pretrained("lxyuan/distilbert-base-multilingual-cased-sentiments-student")
model = AutoModelForSequenceClassification.from_pretrained("lxyuan/distilbert-base-multilingual-cased-sentiments-student")
```

## Mandatory plugins

You will need to install on your DSS instance: 
- [Dataiku's Text Visualization Plugin](https://www.dataiku.com/product/plugins/nlp-visualization/).

### Installing a DSS plugin
[Learn how to install a DSS plugin](https://doc.dataiku.com/dss/latest/plugins/installing.html).

## LLM Mesh connection
This solution uses [Dataiku's LLM Mesh](https://doc.dataiku.com/dss/latest/generative-ai/introduction.html) to interact with local or remote models. One connection needs to be configured to run the project.


# Dataset requirements
For dataset requirements see [Data input](article:11)

Only  **customer_reviews** is mandatory